/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.maven;

import com.buschmais.jqassistant.core.plugin.api.PluginRepository;
import com.buschmais.jqassistant.core.scanner.api.ScannerConfiguration;
import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.scanner.impl.ScannerContextImpl;
import com.buschmais.jqassistant.core.scanner.impl.ScannerImpl;
import com.buschmais.jqassistant.core.scanner.spi.ScannerPluginRepository;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.plugin.common.api.scanner.FileResolver;
import com.buschmais.jqassistant.plugin.maven3.api.artifact.ArtifactResolver;
import com.buschmais.jqassistant.plugin.maven3.api.artifact.MavenRepositoryArtifactResolver;
import com.buschmais.jqassistant.plugin.maven3.api.scanner.MavenScope;
import com.buschmais.jqassistant.plugin.maven3.api.scanner.ScanInclude;
import com.buschmais.jqassistant.scm.maven.AbstractModuleMojo;
import com.buschmais.jqassistant.scm.maven.ProjectResolver;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;

@Mojo(name="scan", defaultPhase=LifecyclePhase.POST_INTEGRATION_TEST, threadSafe=true, configurator="custom")
public class ScanMojo
extends AbstractModuleMojo {
    @Parameter(property="jqassistant.scan.includes")
    protected List<ScanInclude> scanIncludes;
    @Parameter(property="jqassistant.scan.properties")
    private Map<String, Object> scanProperties;
    @Parameter(property="jqassistant.scan.continueOnError")
    private boolean continueOnError = false;
    @Parameter(property="jqassistant.store.reset")
    protected boolean reset = true;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Component(hint="default")
    private DependencyGraphBuilder dependencyGraphBuilder;

    @Override
    protected boolean isResetStoreBeforeExecution() {
        return this.reset;
    }

    @Override
    protected boolean isConnectorRequired() {
        return false;
    }

    protected Map<String, Object> getPluginProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (this.scanProperties != null) {
            properties.putAll(this.scanProperties);
        }
        properties.put(ScanInclude.class.getName(), this.scanIncludes);
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(MavenProject mavenProject, Store store) throws MojoExecutionException {
        this.validate();
        ScannerConfiguration configuration = new ScannerConfiguration();
        configuration.setContinueOnError(this.continueOnError);
        PluginRepository pluginRepository = this.pluginRepositoryProvider.getPluginRepository();
        ScannerPluginRepository scannerPluginRepository = pluginRepository.getScannerPluginRepository();
        ScannerContextImpl scannerContext = new ScannerContextImpl(store, ProjectResolver.getOutputDirectory(mavenProject));
        ScannerImpl scanner = new ScannerImpl(configuration, this.getPluginProperties(), (ScannerContext)scannerContext, scannerPluginRepository);
        File localRepositoryDirectory = this.session.getProjectBuildingRequest().getRepositorySession().getLocalRepository().getBasedir();
        FileResolver fileResolver = (FileResolver)scannerContext.peek(FileResolver.class);
        MavenRepositoryArtifactResolver repositoryArtifactResolver = new MavenRepositoryArtifactResolver(localRepositoryDirectory, fileResolver);
        scannerContext.push(MavenSession.class, (Object)this.session);
        scannerContext.push(ArtifactResolver.class, (Object)repositoryArtifactResolver);
        scannerContext.push(DependencyGraphBuilder.class, (Object)this.dependencyGraphBuilder);
        try {
            scanner.scan((Object)mavenProject, mavenProject.getFile().getAbsolutePath(), (Scope)MavenScope.PROJECT);
        }
        finally {
            scannerContext.pop(DependencyGraphBuilder.class);
            scannerContext.pop(ArtifactResolver.class);
            scannerContext.pop(MavenSession.class);
        }
    }

    private void validate() throws MojoExecutionException {
        if (this.scanIncludes != null) {
            for (ScanInclude scanInclude : this.scanIncludes) {
                if (scanInclude.getPath() == null || scanInclude.getUrl() == null) continue;
                throw new MojoExecutionException("A scanInclude can only include either a file or an URL: path=" + scanInclude.getPath() + ", url=" + scanInclude.getUrl());
            }
        }
    }
}

