/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.maven;

import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.scm.maven.AbstractMojo;
import com.buschmais.jqassistant.scm.maven.ProjectResolver;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public abstract class AbstractProjectMojo
extends AbstractMojo {
    @Override
    public final void execute(MavenProject rootModule, Set<MavenProject> executedModules) throws MojoExecutionException, MojoFailureException {
        Map<MavenProject, List<MavenProject>> projects = ProjectResolver.getProjects(this.reactorProjects, this.rulesDirectory, this.useExecutionRootAsProjectRoot);
        final List<MavenProject> projectModules = projects.get(rootModule);
        boolean isLastModuleInProject = this.isLastModuleInProject(executedModules, projectModules);
        this.getLog().debug((CharSequence)("Verifying if '" + this.currentProject + "' is last module for project '" + rootModule + "': " + isLastModuleInProject + " (project modules='" + projectModules + "')."));
        if (isLastModuleInProject) {
            this.execute(new AbstractMojo.StoreOperation(){

                @Override
                public void run(MavenProject rootModule, Store store) throws MojoExecutionException, MojoFailureException {
                    AbstractProjectMojo.this.aggregate(rootModule, projectModules, store);
                }
            }, rootModule, executedModules);
        }
    }

    private boolean isLastModuleInProject(Set<MavenProject> executedModules, List<MavenProject> projectModules) {
        HashSet<MavenProject> remainingModules = new HashSet<MavenProject>();
        if (this.execution.getPlugin().getExecutions().isEmpty()) {
            this.getLog().debug((CharSequence)"No configured executions found, assuming CLI invocation.");
            remainingModules.addAll(projectModules);
        } else {
            for (MavenProject projectModule : projectModules) {
                if (!ProjectResolver.containsBuildPlugin(projectModule, this.execution.getPlugin())) continue;
                remainingModules.add(projectModule);
            }
        }
        remainingModules.removeAll(executedModules);
        remainingModules.remove(this.currentProject);
        if (remainingModules.isEmpty()) {
            this.getLog().debug((CharSequence)"Did not find any subsequent module with a plugin configuration. Will consider this module as the last one.");
            return true;
        }
        this.getLog().debug((CharSequence)("Found " + remainingModules.size() + " subsequent modules possibly executing this plugin. Will NOT consider this module as the last one."));
        return false;
    }

    protected abstract void aggregate(MavenProject var1, List<MavenProject> var2, Store var3) throws MojoExecutionException, MojoFailureException;
}

