/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.maven;

import com.buschmais.jqassistant.core.analysis.api.AnalyzerConfiguration;
import com.buschmais.jqassistant.core.analysis.api.RuleInterpreterPlugin;
import com.buschmais.jqassistant.core.analysis.api.rule.RuleException;
import com.buschmais.jqassistant.core.analysis.api.rule.RuleSelection;
import com.buschmais.jqassistant.core.analysis.api.rule.RuleSet;
import com.buschmais.jqassistant.core.analysis.api.rule.Severity;
import com.buschmais.jqassistant.core.analysis.impl.AnalyzerImpl;
import com.buschmais.jqassistant.core.plugin.api.PluginRepositoryException;
import com.buschmais.jqassistant.core.report.api.ReportContext;
import com.buschmais.jqassistant.core.report.api.ReportHelper;
import com.buschmais.jqassistant.core.report.api.ReportPlugin;
import com.buschmais.jqassistant.core.report.impl.CompositeReportPlugin;
import com.buschmais.jqassistant.core.report.impl.InMemoryReportPlugin;
import com.buschmais.jqassistant.core.report.impl.ReportContextImpl;
import com.buschmais.jqassistant.core.rule.api.reader.RuleConfiguration;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.scm.maven.AbstractProjectMojo;
import com.buschmais.jqassistant.scm.maven.ProjectResolver;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="analyze", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true, configurator="custom")
public class AnalyzeMojo
extends AbstractProjectMojo {
    private Logger logger = LoggerFactory.getLogger(AnalyzeMojo.class);
    @Parameter(property="jqassistant.ruleParameters")
    protected Map<String, String> ruleParameters;
    @Deprecated
    @Parameter(property="jqassistant.failOnViolations")
    protected Boolean failOnViolations = null;
    @Parameter(property="jqassistant.executeAppliedConcepts")
    protected boolean executeAppliedConcepts = false;
    @Deprecated
    @Parameter(property="jqassistant.severity")
    protected String severity;
    @Parameter(property="jqassistant.warnOnSeverity")
    protected Severity warnOnSeverity = RuleConfiguration.DEFAULT.getDefaultConceptSeverity();
    @Parameter(property="jqassistant.failOnSeverity")
    protected Severity failOnSeverity = RuleConfiguration.DEFAULT.getDefaultConstraintSeverity();
    @Parameter(property="jqassistant.reportTypes")
    private Set<String> reportTypes;
    @Parameter(property="jqassistant.reportProperties")
    private Map<String, Object> reportProperties;

    @Override
    protected boolean isResetStoreBeforeExecution() {
        return false;
    }

    @Override
    protected boolean isConnectorRequired() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void aggregate(MavenProject rootModule, List<MavenProject> projects, Store store) throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("Executing analysis for '" + rootModule.getName() + "'."));
        this.getLog().info((CharSequence)("Will warn on violations starting from severity '" + this.warnOnSeverity + "'"));
        this.getLog().info((CharSequence)("Will fail on violations starting from severity '" + this.failOnSeverity + "'."));
        RuleSet ruleSet = this.readRules(rootModule);
        RuleSelection ruleSelection = RuleSelection.select((RuleSet)ruleSet, (List)this.groups, (List)this.constraints, (List)this.concepts);
        ReportContextImpl reportContext = new ReportContextImpl(ProjectResolver.getOutputDirectory(rootModule));
        Severity effectiveFailOnSeverity = this.getFailOnSeverity();
        Map<String, Object> properties = this.getReportProperties();
        Map<String, ReportPlugin> reportPlugins = this.getReportPlugins((ReportContext)reportContext, properties);
        InMemoryReportPlugin inMemoryReportPlugin = new InMemoryReportPlugin((ReportPlugin)new CompositeReportPlugin(reportPlugins, this.reportTypes.isEmpty() ? null : this.reportTypes));
        AnalyzerConfiguration configuration = new AnalyzerConfiguration();
        configuration.setExecuteAppliedConcepts(this.executeAppliedConcepts);
        try {
            AnalyzerImpl analyzer = new AnalyzerImpl(configuration, store, this.getRuleInterpreterPlugins(), (ReportPlugin)inMemoryReportPlugin, this.logger);
            analyzer.execute(ruleSet, ruleSelection, this.ruleParameters);
        }
        catch (RuleException e) {
            throw new MojoExecutionException("Analysis failed.", (Exception)((Object)e));
        }
        ReportHelper reportHelper = new ReportHelper(this.logger);
        store.beginTransaction();
        try {
            this.verifyAnalysisResults(inMemoryReportPlugin, reportHelper, effectiveFailOnSeverity);
        }
        finally {
            store.commitTransaction();
        }
    }

    private Severity getFailOnSeverity() throws MojoExecutionException {
        Severity effectiveFailOnSeverity;
        if (this.failOnViolations != null) {
            this.getLog().warn((CharSequence)"The parameter 'failOnViolations' is deprecated, please use 'failOnSeverity' instead.");
        }
        if (this.severity != null) {
            this.getLog().warn((CharSequence)"The parameter 'severity' is deprecated, please use 'failOnSeverity' instead.");
            try {
                effectiveFailOnSeverity = Severity.fromValue((String)this.severity);
            }
            catch (RuleException e) {
                throw new MojoExecutionException("Cannot evaluate parameter severity with value " + this.severity);
            }
        } else {
            effectiveFailOnSeverity = this.failOnSeverity;
        }
        return effectiveFailOnSeverity;
    }

    private Map<String, ReportPlugin> getReportPlugins(ReportContext reportContext, Map<String, Object> properties) throws MojoExecutionException {
        Map reportPlugins;
        try {
            reportPlugins = this.pluginRepositoryProvider.getPluginRepository().getReportPluginRepository().getReportPlugins(reportContext, properties);
        }
        catch (PluginRepositoryException e) {
            throw new MojoExecutionException("Cannot get report plugins.", (Exception)((Object)e));
        }
        return reportPlugins;
    }

    private Map<String, Object> getReportProperties() {
        HashMap<String, Object> properties;
        HashMap<String, Object> hashMap = properties = this.reportProperties != null ? this.reportProperties : new HashMap<String, Object>();
        if (this.xmlReportFile != null) {
            properties.put("xml.report.file", this.xmlReportFile.getAbsolutePath());
        }
        return properties;
    }

    private Map<String, Collection<RuleInterpreterPlugin>> getRuleInterpreterPlugins() throws MojoExecutionException {
        try {
            return this.pluginRepositoryProvider.getPluginRepository().getRuleInterpreterPluginRepository().getRuleInterpreterPlugins(Collections.emptyMap());
        }
        catch (PluginRepositoryException e) {
            throw new MojoExecutionException("Cannot get rule interpreter plugins.", (Exception)((Object)e));
        }
    }

    private void verifyAnalysisResults(InMemoryReportPlugin inMemoryReportWriter, ReportHelper reportHelper, Severity effectiveFailOnSeverity) throws MojoFailureException {
        boolean hasViolations;
        int conceptViolations = reportHelper.verifyConceptResults(this.warnOnSeverity, effectiveFailOnSeverity, inMemoryReportWriter);
        int constraintViolations = reportHelper.verifyConstraintResults(this.warnOnSeverity, effectiveFailOnSeverity, inMemoryReportWriter);
        boolean hasConceptViolations = conceptViolations > 0;
        boolean hasConstraintViolations = constraintViolations > 0;
        boolean bl = hasViolations = hasConceptViolations || hasConstraintViolations;
        if (hasViolations) {
            throw new MojoFailureException("Violations detected: " + conceptViolations + " concepts, " + constraintViolations + " constraints");
        }
    }
}

