/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.neo4j.embedded.neo4jv4;

import com.buschmais.jqassistant.neo4j.embedded.EmbeddedNeo4jServer;
import com.buschmais.jqassistant.neo4j.embedded.configuration.Embedded;
import com.buschmais.xo.neo4j.embedded.impl.datastore.EmbeddedDatastore;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.Collection;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.WebAppContext;
import org.neo4j.common.DependencyResolver;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Neo4jV4CommunityNeoServer
implements EmbeddedNeo4jServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(Neo4jV4CommunityNeoServer.class);
    private EmbeddedDatastore embeddedDatastore;
    private Embedded embedded;
    private ClassLoader classLoader;
    private Server server;

    Neo4jV4CommunityNeoServer() {
    }

    @Override
    public String getVersion() {
        return "4.x";
    }

    @Override
    public final void initialize(EmbeddedDatastore embeddedDatastore, Embedded embedded, ClassLoader classLoader, Collection<Class<?>> procedureTypes, Collection<Class<?>> functionTypes) {
        this.embeddedDatastore = embeddedDatastore;
        this.embedded = embedded;
        this.classLoader = classLoader;
        this.registerProceduresAndFunctions(procedureTypes, functionTypes);
    }

    @Override
    public void start() {
        this.server = new Server(new InetSocketAddress(this.embedded.listenAddress(), (int)this.embedded.httpPort()));
        WebAppContext rootContext = this.getWebAppContext("/", "browser/");
        WebAppContext pluginContext = this.getWebAppContext("/jqassistant", "META-INF/jqassistant-static-content/");
        this.server.setHandler((Handler)new HandlerCollection(new Handler[]{rootContext, pluginContext}));
        LOGGER.info("Starting HTTP server.");
        try {
            this.server.start();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot start embedded server.", e);
        }
        LOGGER.info("Neo4j browser available at http://{}:{}.", (Object)this.embedded.listenAddress(), (Object)this.embedded.httpPort());
    }

    private WebAppContext getWebAppContext(String contextPath, String resourceRoot) {
        WebAppContext webAppContext = new WebAppContext();
        webAppContext.setContextPath(contextPath);
        Resource resource = Resource.newResource((URL)this.classLoader.getResource(resourceRoot));
        webAppContext.setBaseResource(resource);
        return webAppContext;
    }

    @Override
    public void stop() {
        if (this.server != null) {
            LOGGER.info("Stopping HTTP server.");
            try {
                this.server.stop();
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot stop embedded server.", e);
            }
        }
    }

    private void registerProceduresAndFunctions(Collection<Class<?>> procedureTypes, Collection<Class<?>> functionTypes) {
        GraphDatabaseService graphDatabaseService = this.embeddedDatastore.getManagementService().database("neo4j");
        GlobalProcedures procedures = (GlobalProcedures)((GraphDatabaseAPI)graphDatabaseService).getDependencyResolver().resolveDependency(GlobalProcedures.class, DependencyResolver.SelectionStrategy.SINGLE);
        for (Class<?> procedureType : procedureTypes) {
            try {
                LOGGER.debug("Registering procedure class " + procedureType.getName());
                procedures.registerProcedure(procedureType);
            }
            catch (KernelException e) {
                LOGGER.warn("Cannot register procedure class " + procedureType.getName(), (Throwable)e);
            }
        }
        for (Class<?> functionType : functionTypes) {
            try {
                LOGGER.debug("Registering function class " + functionType.getName());
                procedures.registerFunction(functionType);
            }
            catch (KernelException e) {
                LOGGER.warn("Cannot register function class " + functionType.getName(), (Throwable)e);
            }
        }
    }
}

