/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.neo4j.backend.neo4jv3;

import com.buschmais.jqassistant.neo4j.backend.bootstrap.AbstractEmbeddedNeo4jServer;
import com.buschmais.jqassistant.neo4j.backend.neo4jv3.extension.StaticContentResource;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.facade.GraphDatabaseDependencies;
import org.neo4j.graphdb.facade.GraphDatabaseFacadeFactory;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.Level;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.database.GraphFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Neo4jV3CommunityNeoServer
extends AbstractEmbeddedNeo4jServer {
    public static final String HTTP_TYPE = "HTTP";
    private static final String DBMS_CONNECTOR_BOLT_ENABLED = "dbms.connector.bolt.enabled";
    private static final String DBMS_CONNECTOR_BOLT_LISTEN_ADDRESS = "dbms.connector.bolt.listen_address";
    private static final String DBMS_CONNECTOR_HTTP_ENABLED = "dbms.connector.http.enabled";
    private static final String DBMS_CONNECTOR_HTTP_LISTEN_ADDRESS = "dbms.connector.http.listen_address";
    private static final String DBMS_CONNECTOR_HTTP_TYPE = "dbms.connector.http.type";
    private static final String DBMS_UNMANAGED_EXTENSION_CLASSES = "dbms.unmanaged_extension_classes";
    private static final String STATIC_CONTENT_ROOT = "/jqassistant/";
    private static final Logger LOGGER = LoggerFactory.getLogger(Neo4jV3CommunityNeoServer.class);
    private CommunityNeoServer communityNeoServer;

    public String getVersion() {
        return "3.x";
    }

    public void start() {
        HashMap<String, String> opts = new HashMap<String, String>();
        opts.put(DBMS_CONNECTOR_HTTP_TYPE, HTTP_TYPE);
        opts.put(DBMS_CONNECTOR_HTTP_ENABLED, Boolean.TRUE.toString());
        opts.put(DBMS_CONNECTOR_HTTP_LISTEN_ADDRESS, this.embeddedNeo4jConfiguration.getListenAddress() + ":" + this.embeddedNeo4jConfiguration.getHttpPort());
        opts.put(DBMS_CONNECTOR_BOLT_ENABLED, Boolean.TRUE.toString());
        opts.put(DBMS_CONNECTOR_BOLT_LISTEN_ADDRESS, this.embeddedNeo4jConfiguration.getListenAddress() + ":" + this.embeddedNeo4jConfiguration.getBoltPort());
        opts.put(DBMS_UNMANAGED_EXTENSION_CLASSES, StaticContentResource.class.getPackage().getName() + "=" + STATIC_CONTENT_ROOT);
        Config defaults = Config.defaults(opts);
        FormattedLogProvider logProvider = FormattedLogProvider.withDefaultLogLevel((Level)Level.INFO).toOutputStream((OutputStream)System.out);
        GraphDatabaseDependencies graphDatabaseDependencies = GraphDatabaseDependencies.newDependencies().userLogProvider((LogProvider)logProvider);
        GraphFactory graphFactory = (config, dependencies) -> (GraphDatabaseFacade)this.graphDatabaseService;
        this.communityNeoServer = new CommunityNeoServer(defaults, graphFactory, (GraphDatabaseFacadeFactory.Dependencies)graphDatabaseDependencies);
        this.communityNeoServer.start();
    }

    public void stop() {
        this.communityNeoServer.stop();
    }

    protected void initialize(Collection<Class<?>> procedureTypes, Collection<Class<?>> functionTypes) {
        Procedures procedures = (Procedures)((GraphDatabaseAPI)this.graphDatabaseService).getDependencyResolver().resolveDependency(Procedures.class, DependencyResolver.SelectionStrategy.ONLY);
        for (Class<?> procedureType : procedureTypes) {
            try {
                LOGGER.debug("Registering procedure class " + procedureType.getName());
                procedures.registerProcedure(procedureType);
            }
            catch (KernelException e) {
                LOGGER.warn("Cannot register procedure class " + procedureType.getName(), (Throwable)e);
            }
        }
        for (Class<?> functionType : functionTypes) {
            try {
                LOGGER.debug("Registering function class " + functionType.getName());
                procedures.registerFunction(functionType);
            }
            catch (KernelException e) {
                LOGGER.warn("Cannot register function class " + functionType.getName(), (Throwable)e);
            }
        }
    }
}

