/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.neo4j.backend.neo4jv3.extension;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Optional;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.tika.Tika;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.server.web.WebServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class StaticContentResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(StaticContentResource.class);
    private static final String CONTENT_PATH = "META-INF/jqassistant-static-content/";
    private static final String INDEX_HTML = "index.html";
    private static final Tika TIKA = new Tika();
    private static final Cache<String, Optional<StaticResource>> RESOURCE_CACHE = Caffeine.newBuilder().maximumSize(256L).build();

    public StaticContentResource(@Context Config configuration, @Context WebServer server) {
        LOGGER.debug("Initializing, serving static content from classpath resources located '{}'.", (Object)CONTENT_PATH);
    }

    @GET
    @Path(value="{file:(?i).+}")
    public Response file(@PathParam(value="file") String file) throws IOException {
        Optional cacheResult = (Optional)RESOURCE_CACHE.get((Object)file, f -> this.resolveFileOrDirectoryResource((String)f));
        if (cacheResult.isPresent()) {
            StaticResource staticResource = (StaticResource)cacheResult.get();
            URL resource = staticResource.getResource();
            String mimeType = staticResource.getMimeType();
            InputStream stream = resource.openStream();
            return mimeType != null ? Response.ok((Object)stream, (String)mimeType).build() : Response.ok((Object)stream).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    private Optional<StaticResource> resolveFileOrDirectoryResource(String path) {
        if (path.endsWith("/")) {
            return this.resolve(path + INDEX_HTML);
        }
        Optional<StaticResource> resource = this.resolve(path + "/" + INDEX_HTML);
        if (resource.isPresent()) {
            return resource;
        }
        return this.resolve(path);
    }

    private Optional<StaticResource> resolve(String resource) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        LOGGER.debug("Resolving resource {} using context class loader {}.", (Object)resource, (Object)contextClassLoader);
        URL url = contextClassLoader.getResource(CONTENT_PATH + resource);
        if (url == null) {
            LOGGER.debug("No classpath resource found for '{}'.", (Object)resource);
            return Optional.empty();
        }
        try {
            String mimeType = TIKA.detect(url);
            LOGGER.debug("Resource {} with mime type {} found for path {}.", new Object[]{url, mimeType, resource});
            return Optional.of(StaticResource.builder().resource(url).mimeType(mimeType).build());
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot determine mime type for " + url, e);
        }
    }

    private static final class StaticResource {
        private final URL resource;
        private final String mimeType;

        public static StaticResourceBuilder builder() {
            return new StaticResourceBuilder();
        }

        public URL getResource() {
            return this.resource;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        private StaticResource(URL resource, String mimeType) {
            this.resource = resource;
            this.mimeType = mimeType;
        }

        public String toString() {
            return "StaticContentResource.StaticResource(resource=" + this.getResource() + ", mimeType=" + this.getMimeType() + ")";
        }

        public static class StaticResourceBuilder {
            private URL resource;
            private String mimeType;

            StaticResourceBuilder() {
            }

            public StaticResourceBuilder resource(URL resource) {
                this.resource = resource;
                return this;
            }

            public StaticResourceBuilder mimeType(String mimeType) {
                this.mimeType = mimeType;
                return this;
            }

            public StaticResource build() {
                return new StaticResource(this.resource, this.mimeType);
            }

            public String toString() {
                return "StaticContentResource.StaticResource.StaticResourceBuilder(resource=" + this.resource + ", mimeType=" + this.mimeType + ")";
            }
        }
    }
}

