/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.asciidocreport;

import com.buschmais.jqassistant.core.report.api.graph.model.SubGraph;
import com.buschmais.jqassistant.core.report.api.model.Result;
import com.buschmais.jqassistant.core.rule.api.model.ExecutableRule;
import com.buschmais.jqassistant.core.rule.api.model.Severity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class RuleResult {
    private ExecutableRule rule;
    private Severity effectiveSeverity;
    private Result.Status status;
    private List<String> columnNames;
    private List<Map<String, List<String>>> rows;
    private SubGraph subGraph;

    public static RuleResultBuilder builder() {
        return new RuleResultBuilder();
    }

    public ExecutableRule getRule() {
        return this.rule;
    }

    public Severity getEffectiveSeverity() {
        return this.effectiveSeverity;
    }

    public Result.Status getStatus() {
        return this.status;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public List<Map<String, List<String>>> getRows() {
        return this.rows;
    }

    public SubGraph getSubGraph() {
        return this.subGraph;
    }

    private RuleResult(ExecutableRule rule, Severity effectiveSeverity, Result.Status status, List<String> columnNames, List<Map<String, List<String>>> rows, SubGraph subGraph) {
        this.rule = rule;
        this.effectiveSeverity = effectiveSeverity;
        this.status = status;
        this.columnNames = columnNames;
        this.rows = rows;
        this.subGraph = subGraph;
    }

    public String toString() {
        return "RuleResult(rule=" + this.getRule() + ", effectiveSeverity=" + this.getEffectiveSeverity() + ", status=" + this.getStatus() + ", columnNames=" + this.getColumnNames() + ", rows=" + this.getRows() + ", subGraph=" + this.getSubGraph() + ")";
    }

    public static class RuleResultBuilder {
        private ExecutableRule rule;
        private Severity effectiveSeverity;
        private Result.Status status;
        private List<String> columnNames;
        private ArrayList<Map<String, List<String>>> rows;
        private SubGraph subGraph;

        RuleResultBuilder() {
        }

        public RuleResultBuilder rule(ExecutableRule rule) {
            this.rule = rule;
            return this;
        }

        public RuleResultBuilder effectiveSeverity(Severity effectiveSeverity) {
            this.effectiveSeverity = effectiveSeverity;
            return this;
        }

        public RuleResultBuilder status(Result.Status status) {
            this.status = status;
            return this;
        }

        public RuleResultBuilder columnNames(List<String> columnNames) {
            this.columnNames = columnNames;
            return this;
        }

        public RuleResultBuilder row(Map<String, List<String>> row) {
            if (this.rows == null) {
                this.rows = new ArrayList();
            }
            this.rows.add(row);
            return this;
        }

        public RuleResultBuilder rows(Collection<? extends Map<String, List<String>>> rows) {
            if (rows == null) {
                throw new NullPointerException("rows cannot be null");
            }
            if (this.rows == null) {
                this.rows = new ArrayList();
            }
            this.rows.addAll(rows);
            return this;
        }

        public RuleResultBuilder clearRows() {
            if (this.rows != null) {
                this.rows.clear();
            }
            return this;
        }

        public RuleResultBuilder subGraph(SubGraph subGraph) {
            this.subGraph = subGraph;
            return this;
        }

        public RuleResult build() {
            List<Object> rows;
            switch (this.rows == null ? 0 : this.rows.size()) {
                case 0: {
                    rows = Collections.emptyList();
                    break;
                }
                case 1: {
                    rows = Collections.singletonList(this.rows.get(0));
                    break;
                }
                default: {
                    rows = Collections.unmodifiableList(new ArrayList<Map<String, List<String>>>(this.rows));
                }
            }
            return new RuleResult(this.rule, this.effectiveSeverity, this.status, this.columnNames, rows, this.subGraph);
        }

        public String toString() {
            return "RuleResult.RuleResultBuilder(rule=" + this.rule + ", effectiveSeverity=" + this.effectiveSeverity + ", status=" + this.status + ", columnNames=" + this.columnNames + ", rows=" + this.rows + ", subGraph=" + this.subGraph + ")";
        }
    }
}

