/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.asciidocreport;

import com.buschmais.jqassistant.core.report.api.ReportContext;
import com.buschmais.jqassistant.core.rule.api.model.ExecutableRule;
import com.buschmais.jqassistant.core.shared.asciidoc.DocumentParser;
import com.buschmais.jqassistant.plugin.asciidocreport.RuleResult;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringEscapeUtils;
import org.asciidoctor.ast.ContentNode;
import org.asciidoctor.ast.Document;
import org.asciidoctor.ast.StructuralNode;
import org.asciidoctor.extension.Treeprocessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreePreprocessor
extends Treeprocessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TreePreprocessor.class);
    private final DocumentParser documentParser;
    private final Map<String, RuleResult> conceptResults;
    private final Map<String, RuleResult> constraintResults;
    private final File reportDirectory;
    private final ReportContext reportContext;

    public TreePreprocessor(DocumentParser documentParser, Map<String, RuleResult> conceptResults, Map<String, RuleResult> constraintResults, File reportDirectory, ReportContext reportContext) {
        this.documentParser = documentParser;
        this.conceptResults = conceptResults;
        this.constraintResults = constraintResults;
        this.reportDirectory = reportDirectory;
        this.reportContext = reportContext;
    }

    public Document process(Document document) {
        DocumentParser.Result result = this.documentParser.parse(document);
        this.enrichResults(result.getConcepts(), this.conceptResults);
        this.enrichResults(result.getConstraints(), this.constraintResults);
        return document;
    }

    private void enrichResults(Map<String, StructuralNode> blocks, Map<String, RuleResult> results) {
        for (Map.Entry<String, StructuralNode> blockEntry : blocks.entrySet()) {
            String id = blockEntry.getKey();
            StructuralNode block = blockEntry.getValue();
            RuleResult result = results.get(id);
            List<String> content = this.renderRuleResult(result);
            ContentNode parent = block.getParent();
            List siblings = ((StructuralNode)parent).getBlocks();
            int i = siblings.indexOf(block);
            siblings.add(i + 1, this.createBlock((StructuralNode)parent, "paragraph", content, new HashMap(), new HashMap()));
        }
    }

    private List<String> renderRuleResult(RuleResult result) {
        ArrayList<String> content = new ArrayList<String>();
        if (result != null) {
            ExecutableRule rule = result.getRule();
            List reports = this.reportContext.getReports(rule);
            content.add("<div id=\"result(" + rule.getId() + ")\">");
            if (!reports.isEmpty()) {
                for (ReportContext.Report report : reports) {
                    switch (report.getReportType()) {
                        case IMAGE: {
                            content.add(this.renderImage(this.getReportUrl(report)));
                            break;
                        }
                        case LINK: {
                            content.add(this.renderDownloadLink(this.getReportUrl(report), report.getLabel()));
                        }
                    }
                }
            } else if (!result.getRows().isEmpty()) {
                content.add(this.renderResultTable(result));
            }
            content.add("</div>");
        }
        return content;
    }

    private String getReportUrl(ReportContext.Report<?> report) {
        URL url = report.getUrl();
        String protocol = url.getProtocol();
        if ("file".equals(protocol)) {
            return this.getRelativeReportUrl(url);
        }
        return url.toExternalForm();
    }

    private String getRelativeReportUrl(URL url) {
        Path path;
        try {
            path = Paths.get(url.toURI());
        }
        catch (URISyntaxException e) {
            LOGGER.warn("Cannot determine path from URL '" + url + "'.", (Throwable)e);
            return url.toExternalForm();
        }
        Path relativePath = this.reportDirectory.getAbsoluteFile().toPath().relativize(path);
        return relativePath.toString().replace('\\', '/');
    }

    private String renderDownloadLink(String url, String label) {
        StringBuilder a = new StringBuilder();
        a.append("<span class=\"fa fa-download\"/>");
        a.append("<a href=").append('\"').append(url).append('\"').append(" style=\"text-decoration:none; color:initial\">");
        a.append("<b>");
        a.append(label);
        a.append("</b>");
        a.append("</a>");
        return a.toString();
    }

    private String renderResultTable(RuleResult result) {
        List<String> columnNames = result.getColumnNames();
        StringBuilder tableBuilder = new StringBuilder();
        tableBuilder.append("<table>").append('\n');
        tableBuilder.append("<thead>").append('\n');
        tableBuilder.append("<tr>").append('\n');
        for (String string : columnNames) {
            tableBuilder.append("<th>").append(string).append("</th>").append('\n');
        }
        tableBuilder.append("</tr>").append('\n');
        tableBuilder.append("</thead>").append('\n');
        tableBuilder.append("<tbody>").append('\n');
        for (Map map : result.getRows()) {
            tableBuilder.append("<tr>").append('\n');
            for (String columnName : columnNames) {
                tableBuilder.append("<td>").append('\n');
                for (String value : (List)map.get(columnName)) {
                    tableBuilder.append(StringEscapeUtils.escapeHtml4((String)value)).append('\n');
                }
                tableBuilder.append("</td>").append('\n');
            }
            tableBuilder.append("</tr>").append('\n');
        }
        tableBuilder.append("</tbody>").append('\n');
        tableBuilder.append("</table>").append('\n');
        return tableBuilder.toString();
    }

    private String renderImage(String url) {
        StringBuilder content = new StringBuilder();
        content.append("<div>");
        content.append("<a href=\"" + url + "\">");
        content.append("<img src=\"" + url + "\"/>");
        content.append("</a>");
        content.append("</div>");
        return content.toString();
    }
}

