/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.asciidocreport.include;

import com.buschmais.jqassistant.core.report.api.model.Result;
import com.buschmais.jqassistant.core.rule.api.model.ExecutableRule;
import com.buschmais.jqassistant.plugin.asciidocreport.RuleResult;
import com.buschmais.jqassistant.plugin.asciidocreport.StatusHelper;
import com.buschmais.jqassistant.plugin.asciidocreport.include.AbstractIncludeStrategy;
import com.buschmais.jqassistant.plugin.asciidocreport.include.SummaryFilter;
import java.util.Collection;
import java.util.Map;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SummaryIncludeStrategy
extends AbstractIncludeStrategy {
    private static final Logger log = LoggerFactory.getLogger(SummaryIncludeStrategy.class);
    private final SummaryFilter summaryFilter;

    public SummaryIncludeStrategy(Map<String, RuleResult> conceptResults, Map<String, RuleResult> constraintResults, SummaryFilter summaryFilter) {
        super(conceptResults, constraintResults);
        this.summaryFilter = summaryFilter;
    }

    @Override
    public String getName() {
        return "Summary";
    }

    @Override
    public void process(Map<String, Object> attributes, StringBuilder builder) {
        SummaryFilter.Result result = this.summaryFilter.apply(attributes);
        this.includeSummaryTable("Constraints", "constraintRef", result.getConstraints(), builder);
        this.includeSummaryTable("Concepts", "conceptRef", result.getConcepts(), builder);
    }

    private void includeSummaryTable(String title, String referenceMacro, Collection<RuleResult> results, StringBuilder builder) {
        if (!results.isEmpty()) {
            builder.append('.').append(title).append('\n');
            builder.append("[options=header,role=summary]").append('\n');
            builder.append("|===").append('\n');
            builder.append("| Id | Description | Severity | Status").append('\n');
            TreeSet<RuleResult> ruleResults = new TreeSet<RuleResult>(StatusHelper.getRuleResultComparator());
            ruleResults.addAll(results);
            for (RuleResult result : ruleResults) {
                ExecutableRule rule = result.getRule();
                builder.append("| ").append("jQA:").append(referenceMacro).append('[').append(rule.getId()).append(']');
                builder.append("| ").append(this.escape(rule.getDescription()));
                builder.append("| ").append(rule.getSeverity().getInfo(result.getEffectiveSeverity()));
                Result.Status status = result.getStatus();
                String statusClass = StatusHelper.getStatusClass(status);
                builder.append("| ").append("[").append(statusClass).append("]#").append(status.toString()).append('#').append('\n');
            }
            builder.append("|===").append('\n');
        }
    }
}

