/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.asciidocreport.plantuml;

import com.buschmais.jqassistant.core.report.api.ReportException;
import com.buschmais.jqassistant.core.rule.api.model.ExecutableRule;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SourceStringReader;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageRenderer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageRenderer.class);

    public File renderDiagram(String plantUML, ExecutableRule rule, File directory, String format) throws ReportException {
        String diagramFileNamePrefix = rule.getId().replaceAll("\\:", "_");
        File plantUMLFile = new File(directory, diagramFileNamePrefix + ".plantuml");
        try {
            FileUtils.writeStringToFile((File)plantUMLFile, (String)plantUML, (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new ReportException("Cannot write PlantUML diagram to " + plantUMLFile.getPath(), (Throwable)e);
        }
        FileFormat fileFormat = this.toFileFormat(format);
        String diagramFileName = diagramFileNamePrefix + fileFormat.getFileSuffix();
        File file = new File(directory, diagramFileName);
        this.renderDiagram(plantUML, file, fileFormat);
        return file;
    }

    private void renderDiagram(String plantUML, File file, FileFormat format) throws ReportException {
        LOGGER.info("Rendering diagram '{}' ", (Object)file.getPath());
        SourceStringReader reader = new SourceStringReader(plantUML);
        try (FileOutputStream os = new FileOutputStream(file);){
            reader.outputImage((OutputStream)os, new FileFormatOption(format));
        }
        catch (IOException e) {
            throw new ReportException("Cannot create component diagram for file " + file.getPath());
        }
    }

    private FileFormat toFileFormat(String format) throws ReportException {
        for (FileFormat fileFormat : FileFormat.values()) {
            if (!fileFormat.name().equalsIgnoreCase(format)) continue;
            return fileFormat;
        }
        throw new ReportException(format + " is not a valid FileFormat");
    }
}

