/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.asciidocreport.plantuml.sequence;

import com.buschmais.jqassistant.core.report.api.ReportException;
import com.buschmais.jqassistant.core.report.api.graph.SubGraphFactory;
import com.buschmais.jqassistant.core.report.api.graph.model.Identifiable;
import com.buschmais.jqassistant.core.report.api.graph.model.Node;
import com.buschmais.jqassistant.core.report.api.graph.model.Relationship;
import com.buschmais.jqassistant.core.report.api.model.Result;
import com.buschmais.jqassistant.core.rule.api.model.ExecutableRule;
import com.buschmais.jqassistant.plugin.asciidocreport.plantuml.AbstractDiagramRenderer;
import com.buschmais.jqassistant.plugin.asciidocreport.plantuml.RenderMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceDiagramRenderer
extends AbstractDiagramRenderer {
    public static final String COLUMN_SEQUENCE = "sequence";
    public static final String COLUMN_PARTICIPANTS = "participants";
    public static final String COLUMN_MESSAGES = "messages";
    private static final Logger LOGGER = LoggerFactory.getLogger(SequenceDiagramRenderer.class);
    private final SubGraphFactory subGraphFactory;

    SequenceDiagramRenderer(SubGraphFactory subGraphFactory, RenderMode renderMode) {
        super(renderMode);
        this.subGraphFactory = subGraphFactory;
    }

    @Override
    protected void render(Result<? extends ExecutableRule> result, StringBuilder builder) throws ReportException {
        List rows = result.getRows();
        LinkedHashSet<Node> participants = new LinkedHashSet<Node>();
        LinkedHashSet<Relationship> messages = new LinkedHashSet<Relationship>();
        this.convertResult(rows, participants, messages);
        LOGGER.info("Rendering sequence diagram with {} participants and {} messages.", (Object)participants.size(), (Object)messages.size());
        this.renderParticipants(participants, builder);
        builder.append('\n');
        this.renderRelationships(messages, builder);
    }

    private void convertResult(List<Map<String, Object>> rows, Set<Node> participants, Set<Relationship> messages) throws ReportException {
        for (Map<String, Object> row : rows) {
            List sequence = row.getOrDefault(COLUMN_SEQUENCE, Collections.emptyList());
            if (!sequence.isEmpty()) {
                for (Object value : sequence) {
                    Identifiable identifiable = this.subGraphFactory.toIdentifiable(value);
                    if (identifiable instanceof Node) {
                        participants.add((Node)identifiable);
                        continue;
                    }
                    if (!(identifiable instanceof Relationship)) continue;
                    messages.add((Relationship)identifiable);
                }
                continue;
            }
            List nodes = row.getOrDefault(COLUMN_PARTICIPANTS, Collections.emptyList());
            participants.addAll(this.convert(nodes, this.subGraphFactory));
            List relationships = row.getOrDefault(COLUMN_MESSAGES, Collections.emptyList());
            messages.addAll(this.convert(relationships, this.subGraphFactory));
        }
    }

    private <T extends Identifiable> List<T> convert(List<?> elements, SubGraphFactory subGraphFactory) throws ReportException {
        ArrayList<Identifiable> result = new ArrayList<Identifiable>(elements.size());
        for (Object element : elements) {
            result.add(subGraphFactory.toIdentifiable(element));
        }
        return result;
    }

    private void renderParticipants(Collection<Node> participants, StringBuilder builder) {
        for (Node participant : participants) {
            builder.append("participant ").append('\"').append(participant.getLabel()).append('\"').append(" as ").append(this.getNodeId(participant));
            Set labels = participant.getLabels();
            for (String label : labels) {
                builder.append(" <<");
                builder.append(label);
                builder.append(">>");
            }
            builder.append('\n');
        }
    }

    private void renderRelationships(Collection<Relationship> messages, StringBuilder builder) {
        for (Relationship relationship : messages) {
            Node startNode = relationship.getStartNode();
            Node endNode = relationship.getEndNode();
            builder.append(this.getNodeId(startNode)).append(" -> ").append(this.getNodeId(endNode)).append(" : ").append(relationship.getType()).append('\n');
        }
        builder.append('\n');
    }
}

