/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.asciidocreport;

import com.buschmais.jqassistant.core.shared.asciidoc.DocumentParser;
import java.util.HashMap;
import java.util.Map;
import org.asciidoctor.ast.ContentNode;
import org.asciidoctor.ast.StructuralNode;

public class InlineMacroProcessor
extends org.asciidoctor.extension.InlineMacroProcessor {
    public static final String CONCEPT_REF = "conceptRef";
    public static final String CONSTRAINT_REF = "constraintRef";
    private final DocumentParser documentParser;

    public InlineMacroProcessor(DocumentParser documentParser) {
        super("jQA");
        this.documentParser = documentParser;
    }

    public Object process(ContentNode parent, String target, Map<String, Object> attributes) {
        if (CONCEPT_REF.equals(target)) {
            DocumentParser.Result result = this.documentParser.parse(parent.getDocument());
            return this.processRef(parent, attributes, result.getConcepts());
        }
        if (CONSTRAINT_REF.equals(target)) {
            DocumentParser.Result result = this.documentParser.parse(parent.getDocument());
            return this.processRef(parent, attributes, result.getConstraints());
        }
        throw new IllegalArgumentException("Unknown jQAssistant macro '" + target + "'");
    }

    private Object processRef(ContentNode parent, Map<String, Object> attributes, Map<String, StructuralNode> blocks) {
        Object rule = attributes.get("1");
        if (rule != null && blocks.containsKey(rule)) {
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("type", ":link");
            options.put("target", "#" + rule);
            return this.createPhraseNode(parent, "anchor", rule.toString(), attributes, options);
        }
        return rule;
    }
}

