/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.asciidocreport;

import com.buschmais.jqassistant.core.report.api.ReportException;
import com.buschmais.jqassistant.core.rule.api.source.RuleSource;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FilePatternMatcher;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceFileMatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(SourceFileMatcher.class);
    private static final String DEFAULT_INDEX_FILE = "index.adoc";
    private final File ruleDirectory;
    private final String fileInclude;
    private final String fileExclude;

    SourceFileMatcher(File ruleDirectory, String fileInclude, String fileExclude) {
        this.ruleDirectory = ruleDirectory;
        this.fileInclude = fileInclude;
        this.fileExclude = fileExclude;
    }

    public Map<File, List<File>> match(Set<RuleSource> ruleSources) throws ReportException {
        HashMap<File, List<File>> files = new HashMap<File, List<File>>();
        if (this.ruleDirectory != null) {
            if (this.ruleDirectory.exists()) {
                files.put(this.ruleDirectory, this.matchFilesFromRuleDirectory());
            } else {
                LOGGER.warn("Specified rule directory does not exist: '{}'.", (Object)this.ruleDirectory.getAbsolutePath());
            }
        } else {
            for (RuleSource ruleSource : ruleSources) {
                File file;
                String path;
                URL url;
                try {
                    url = ruleSource.getURL();
                }
                catch (IOException e) {
                    throw new ReportException("Cannot get URL from file " + ruleSource, (Throwable)e);
                }
                if (!"file".equals(url.getProtocol()) || !(path = url.getPath()).endsWith("/index.adoc")) continue;
                try {
                    file = new File(URLDecoder.decode(url.getFile(), Charset.defaultCharset().toString()));
                }
                catch (UnsupportedEncodingException e) {
                    throw new ReportException("Cannot get URL from file " + ruleSource, (Throwable)e);
                }
                LOGGER.info("Found index document '{}'.", (Object)file);
                File directory = file.getParentFile();
                ArrayList<File> filesByDirectory = (ArrayList<File>)files.get(directory);
                if (filesByDirectory == null) {
                    filesByDirectory = new ArrayList<File>();
                    files.put(directory, filesByDirectory);
                }
                filesByDirectory.add(file);
            }
        }
        return files;
    }

    private List<File> matchFilesFromRuleDirectory() {
        FilePatternMatcher filePatternMatcher = FilePatternMatcher.builder().include(this.fileInclude).exclude(this.fileExclude).build();
        return Arrays.asList(this.ruleDirectory.listFiles(file -> file.isFile() && filePatternMatcher.accepts(file.getName())));
    }
}

