/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.asciidocreport;

import com.buschmais.jqassistant.core.report.api.model.Result;
import com.buschmais.jqassistant.core.rule.api.model.Severity;
import com.buschmais.jqassistant.plugin.asciidocreport.RuleResult;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class StatusHelper {
    private static final RuleResultComparator RULE_RESULT_COMPARATOR = new RuleResultComparator();

    public static String getStatusClass(Result.Status status) {
        switch (status) {
            case SUCCESS: {
                return "jqassistant-status-success";
            }
            case FAILURE: {
                return "jqassistant-status-failure";
            }
            case SKIPPED: {
                return "jqassistant-status-skipped";
            }
        }
        throw new IllegalArgumentException("Unknown status " + status);
    }

    public static Comparator<RuleResult> getRuleResultComparator() {
        return RULE_RESULT_COMPARATOR;
    }

    private static class RuleResultComparator
    implements Comparator<RuleResult> {
        private Map<Result.Status, Integer> statusLevels = new HashMap<Result.Status, Integer>();

        private RuleResultComparator() {
            this.statusLevels.put(Result.Status.FAILURE, 0);
            this.statusLevels.put(Result.Status.SUCCESS, 1);
            this.statusLevels.put(Result.Status.SKIPPED, 2);
        }

        @Override
        public int compare(RuleResult o1, RuleResult o2) {
            Severity effectiveSeverity2;
            Result.Status status2;
            Result.Status status1 = o1.getStatus();
            if (!status1.equals((Object)(status2 = o2.getStatus()))) {
                return this.statusLevels.get(status1).compareTo(this.statusLevels.get(status2));
            }
            Severity effectiveSeverity1 = this.getEffectiveSeverity(o1);
            if (!effectiveSeverity1.equals((Object)(effectiveSeverity2 = this.getEffectiveSeverity(o2)))) {
                return effectiveSeverity1.compareTo((Enum)effectiveSeverity2);
            }
            return o1.getRule().getId().compareTo(o2.getRule().getId());
        }

        private Severity getEffectiveSeverity(RuleResult result) {
            Severity severity = result.getEffectiveSeverity();
            return severity != null ? severity : result.getRule().getSeverity();
        }
    }
}

