/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.asciidocreport;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.asciidoctor.ast.Document;
import org.asciidoctor.extension.IncludeProcessor;
import org.asciidoctor.extension.PreprocessorReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginIncludeProcessor
extends IncludeProcessor {
    private static final Logger log = LoggerFactory.getLogger(PluginIncludeProcessor.class);
    private final String rootPath;

    public PluginIncludeProcessor(String path) {
        StringBuilder builder = new StringBuilder("/");
        int lastFileSeparatorIndex = path.lastIndexOf(47);
        if (lastFileSeparatorIndex >= 0) {
            builder.append(path, 0, lastFileSeparatorIndex);
        }
        builder.append('/');
        this.rootPath = builder.toString();
    }

    public boolean handles(String target) {
        return this.getClasspathResource(target).isPresent();
    }

    public void process(Document document, PreprocessorReader reader, String target, Map<String, Object> attributes) {
        this.getClasspathResource(target).ifPresent(url -> {
            try (InputStream inputStream = url.openConnection().getInputStream();){
                reader.pushInclude(IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8), target, url.toExternalForm(), 1, attributes);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot open input stream for class path resource " + url);
            }
        });
    }

    private Optional<URL> getClasspathResource(String target) {
        StringBuilder resource = new StringBuilder("META-INF/jqassistant-rules");
        if (!target.startsWith("/")) {
            resource.append(this.rootPath);
        }
        resource.append(target);
        log.debug("Mapped include target '{}' to class path resource '{}'.", (Object)target, (Object)resource);
        return Optional.ofNullable(Thread.currentThread().getContextClassLoader().getResource(resource.toString()));
    }
}

