/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.asciidocreport;

import com.buschmais.jqassistant.core.report.api.model.Result;
import com.buschmais.jqassistant.core.rule.api.model.ExecutableRule;
import com.buschmais.jqassistant.plugin.asciidocreport.RuleResult;
import com.buschmais.jqassistant.plugin.asciidocreport.StatusHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.asciidoctor.ast.Document;
import org.asciidoctor.extension.Postprocessor;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;

public class RulePostProcessor
extends Postprocessor {
    private final Map<String, RuleResult> conceptResults;
    private final Map<String, RuleResult> constraintResults;

    public RulePostProcessor(Map<String, RuleResult> conceptResults, Map<String, RuleResult> constraintResults) {
        this.conceptResults = conceptResults;
        this.constraintResults = constraintResults;
    }

    public String process(Document document, String output) {
        if (document.basebackend("html")) {
            return HtmlRulePostProcessor.process(this.conceptResults, this.constraintResults, output);
        }
        return output;
    }

    public static class HtmlRulePostProcessor {
        static String process(Map<String, RuleResult> conceptResults, Map<String, RuleResult> constraintResults, String output) {
            org.jsoup.nodes.Document doc = Jsoup.parse((String)output, (String)"UTF-8");
            ArrayList<String> contentIds = new ArrayList<String>();
            HtmlRulePostProcessor.processRuleBlocks(doc, "concept", conceptResults, contentIds);
            HtmlRulePostProcessor.processRuleBlocks(doc, "constraint", constraintResults, contentIds);
            HtmlRulePostProcessor.addStyles(doc, contentIds);
            return doc.html();
        }

        private static void processRuleBlocks(org.jsoup.nodes.Document doc, String ruleClass, Map<String, RuleResult> ruleResults, List<String> contentIds) {
            Elements ruleBlocks = doc.getElementsByClass(ruleClass);
            for (Element ruleBlock : ruleBlocks) {
                HtmlRulePostProcessor.addStatus(ruleBlock, ruleResults);
                if (!ruleBlock.hasClass("listingblock")) continue;
                HtmlRulePostProcessor.hideListing(ruleBlock, contentIds);
            }
        }

        private static void addStatus(Element ruleBlock, Map<String, RuleResult> ruleResults) {
            Element status;
            Elements title = ruleBlock.getElementsByClass("title");
            Element titleElement = title.first();
            if (titleElement != null) {
                status = new Element("div");
                titleElement.before((Node)status);
                titleElement.attr("style", "display:inline;");
            } else {
                status = ruleBlock.prependElement("div");
            }
            status.addClass("jqassistant-rule-status");
            RuleResult ruleResult = ruleResults.get(ruleBlock.id());
            if (ruleResult != null) {
                ExecutableRule rule = ruleResult.getRule();
                status.addClass(StatusHelper.getStatusClass(ruleResult.getStatus()));
                switch (ruleResult.getStatus()) {
                    case SUCCESS: {
                        status.addClass("fa").addClass("fa-check");
                        break;
                    }
                    case FAILURE: {
                        status.addClass("fa").addClass("fa-ban");
                    }
                }
                String hover = "Status: " + ruleResult.getStatus() + ", Severity: " + rule.getSeverity().getInfo(ruleResult.getEffectiveSeverity());
                status.attr("title", hover);
            } else {
                status.addClass("fa").addClass("fa-question");
                status.attr("title", "Rule has not been executed.");
            }
        }

        private static void hideListing(Element ruleBlock, List<String> contentIds) {
            String contentId = "jqassistant-rule-listing" + contentIds.size();
            contentIds.add(contentId);
            Elements contents = ruleBlock.getElementsByClass("content");
            Element content = contents.first();
            content.before("<input type=\"checkbox\" class=\"jqassistant-rule-toggle\" title=\"Rule details\"/>");
            contents.attr("id", contentId);
        }

        private static void addStyles(org.jsoup.nodes.Document doc, List<String> contentIds) {
            StringBuilder styles = new StringBuilder();
            styles.append("<style>\n");
            for (String contentId : contentIds) {
                styles.append("#").append(contentId).append("{\n");
                styles.append("  display:none;\n");
                styles.append("}\n");
                styles.append("input.jqassistant-rule-toggle:checked + #").append(contentId).append("{\n");
                styles.append("  display:block;\n");
                styles.append("}\n");
            }
            styles.append("." + StatusHelper.getStatusClass(Result.Status.SUCCESS) + "{color: green}");
            styles.append("." + StatusHelper.getStatusClass(Result.Status.FAILURE) + "{color: crimson}");
            styles.append("." + StatusHelper.getStatusClass(Result.Status.SKIPPED) + "{color: yellow}");
            styles.append("</style>\n");
            doc.head().append(styles.toString());
        }
    }
}

