/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.asciidocreport.include;

import com.buschmais.jqassistant.core.rule.api.model.Concept;
import com.buschmais.jqassistant.core.rule.api.model.Constraint;
import com.buschmais.jqassistant.core.rule.api.model.CypherExecutable;
import com.buschmais.jqassistant.core.rule.api.model.Executable;
import com.buschmais.jqassistant.core.rule.api.model.ExecutableRule;
import com.buschmais.jqassistant.core.rule.api.model.ScriptExecutable;
import com.buschmais.jqassistant.plugin.asciidocreport.RuleResult;
import com.buschmais.jqassistant.plugin.asciidocreport.include.AbstractIncludeStrategy;
import java.util.Map;
import java.util.Set;
import org.asciidoctor.ast.StructuralNode;

public abstract class AbstractIncludeRulesStrategy
extends AbstractIncludeStrategy {
    protected final Map<String, StructuralNode> ruleBlocks;
    private final Set<ExecutableRule<?>> includedRules;

    protected AbstractIncludeRulesStrategy(Map<String, RuleResult> conceptResults, Map<String, RuleResult> constraintResults, Map<String, StructuralNode> ruleBlocks, Set<ExecutableRule<?>> includedRules) {
        super(conceptResults, constraintResults);
        this.ruleBlocks = ruleBlocks;
        this.includedRules = includedRules;
    }

    protected void includeRuleResult(RuleResult ruleResult, StringBuilder builder) {
        ExecutableRule rule = ruleResult.getRule();
        if (!this.ruleBlocks.containsKey(rule.getId()) && this.includedRules.add(rule)) {
            String ruleType;
            builder.append("[[").append(rule.getId()).append("]]").append('\n');
            String language = null;
            String source = null;
            Executable executable = rule.getExecutable();
            if (executable instanceof CypherExecutable) {
                language = "cypher";
                source = (String)((CypherExecutable)executable).getSource();
            } else if (executable instanceof ScriptExecutable) {
                ScriptExecutable scriptExecutable = (ScriptExecutable)executable;
                language = executable.getLanguage();
                source = (String)scriptExecutable.getSource();
            }
            if (rule instanceof Concept) {
                ruleType = "concept";
            } else if (rule instanceof Constraint) {
                ruleType = "constraint";
            } else {
                throw new IllegalArgumentException("Cannot determine type of rule " + executable);
            }
            builder.append("[source,").append(language).append(",role=").append(ruleType).append(",indent=0").append("]").append('\n');
            builder.append('.').append(this.escape(rule.getDescription())).append('\n');
            builder.append("----").append('\n');
            if (source != null) {
                builder.append(source).append('\n');
            }
            builder.append("----").append('\n');
            builder.append('\n');
        }
    }
}

