/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.asciidocreport.plantuml.clazz;

import com.buschmais.jqassistant.core.report.api.ReportException;
import com.buschmais.jqassistant.core.report.api.graph.model.Node;
import com.buschmais.jqassistant.core.report.api.graph.model.Relationship;
import com.buschmais.jqassistant.core.report.api.model.Result;
import com.buschmais.jqassistant.core.rule.api.model.ExecutableRule;
import com.buschmais.jqassistant.plugin.asciidocreport.plantuml.AbstractDiagramRenderer;
import com.buschmais.jqassistant.plugin.asciidocreport.plantuml.RenderMode;
import com.buschmais.jqassistant.plugin.asciidocreport.plantuml.clazz.ClassDiagramResult;
import com.buschmais.jqassistant.plugin.asciidocreport.plantuml.clazz.ClassDiagramResultConverter;
import com.buschmais.jqassistant.plugin.java.api.model.AbstractDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.AccessModifierDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.AnnotationTypeDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.EnumTypeDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.FieldDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.InterfaceTypeDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.JavaByteCodeDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.MemberDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.MethodDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.PackageDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.PackageMemberDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.TypeDescriptor;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class ClassDiagramRenderer
extends AbstractDiagramRenderer {
    private static final String DEFAULT_RELATION_TYPE = "-->";
    private ClassDiagramResultConverter classDiagramResultConverter;
    private Map<String, String> relationTypes;

    public ClassDiagramRenderer(ClassDiagramResultConverter classDiagramResultConverter, RenderMode renderMode) {
        super(renderMode);
        this.classDiagramResultConverter = classDiagramResultConverter;
        this.relationTypes = new HashMap<String, String>();
        this.relationTypes.put("EXTENDS", "--|>");
        this.relationTypes.put("IMPLEMENTS", "..|>");
    }

    @Override
    protected void render(Result<? extends ExecutableRule> result, StringBuilder builder) throws ReportException {
        ClassDiagramResult classDiagramResult = this.classDiagramResultConverter.convert(result);
        Set<PackageMemberDescriptor> rootMembers = classDiagramResult.getPackageMemberTree().getOrDefault(null, Collections.emptySet());
        Set<FieldDescriptor> fieldAssociations = this.renderPackageMembers(rootMembers, classDiagramResult, 0, builder);
        this.renderAssociations(classDiagramResult.getPackageMembers(), fieldAssociations, builder);
        HashSet<Node> packageMemberNodes = new HashSet<Node>(classDiagramResult.getPackageMembers().values());
        this.renderRelations(packageMemberNodes, classDiagramResult, builder);
    }

    private Set<FieldDescriptor> renderPackageMembers(Set<PackageMemberDescriptor> packageMembers, ClassDiagramResult classDiagramResult, int level, StringBuilder builder) {
        LinkedHashSet<FieldDescriptor> fieldAssociations = new LinkedHashSet<FieldDescriptor>();
        for (PackageMemberDescriptor packageMember : packageMembers) {
            builder.append(this.indent(level));
            Node node = classDiagramResult.getPackageMembers().get(packageMember);
            if (packageMember instanceof PackageDescriptor) {
                builder.append("package").append(' ').append(this.getNodeId(node)).append(" as ").append('\"').append(packageMember.getFullQualifiedName()).append('\"');
                builder.append("{\n");
                Set<PackageMemberDescriptor> children = classDiagramResult.getPackageMemberTree().get(packageMember);
                fieldAssociations.addAll(this.renderPackageMembers(children, classDiagramResult, level + 1, builder));
                builder.append("}");
            } else if (packageMember instanceof TypeDescriptor) {
                TypeDescriptor type = (TypeDescriptor)packageMember;
                if (type instanceof AccessModifierDescriptor) {
                    builder.append(this.getVisibility((AccessModifierDescriptor)type));
                }
                if (this.isAbstract((JavaByteCodeDescriptor)type) && !(type instanceof EnumTypeDescriptor)) {
                    builder.append("abstract").append(" ");
                }
                builder.append(this.getType(type)).append(" ").append(this.getNodeId(node)).append(" as ").append('\"').append(packageMember.getFullQualifiedName()).append('\"');
                if (!(type instanceof AnnotationTypeDescriptor)) {
                    builder.append("{\n");
                    Set<MemberDescriptor> typeMembers = classDiagramResult.getMembersPerType().getOrDefault(type, Collections.emptySet());
                    fieldAssociations.addAll(this.renderTypeMembers(typeMembers, classDiagramResult, level + 1, builder));
                    builder.append(this.indent(level)).append('}');
                }
            }
            builder.append("\n");
        }
        return fieldAssociations;
    }

    private Set<FieldDescriptor> renderTypeMembers(Set<MemberDescriptor> typeMembers, ClassDiagramResult classDiagramResult, int level, StringBuilder builder) {
        LinkedHashSet<FieldDescriptor> fieldAssociations = new LinkedHashSet<FieldDescriptor>();
        for (MemberDescriptor member : typeMembers) {
            if (member instanceof FieldDescriptor) {
                FieldDescriptor field = (FieldDescriptor)member;
                if (!this.isStatic((MemberDescriptor)field) && classDiagramResult.getPackageMembers().containsKey(field.getType())) {
                    fieldAssociations.add(field);
                    continue;
                }
                this.renderMemberSignature(member, level, builder);
                continue;
            }
            if (!(member instanceof MethodDescriptor)) continue;
            this.renderMemberSignature(member, level, builder);
        }
        return fieldAssociations;
    }

    private void renderAssociations(Map<PackageMemberDescriptor, Node> packageMembers, Set<FieldDescriptor> fieldAssociations, StringBuilder builder) {
        for (FieldDescriptor fieldAssociation : fieldAssociations) {
            TypeDescriptor declaringType = fieldAssociation.getDeclaringType();
            TypeDescriptor fieldType = fieldAssociation.getType();
            builder.append(this.getNodeId(packageMembers.get(declaringType)));
            builder.append(" -> ");
            builder.append(this.getNodeId(packageMembers.get(fieldType)));
            builder.append(" : ").append(this.getVisibility((AccessModifierDescriptor)fieldAssociation)).append(fieldAssociation.getName());
            builder.append("\n");
        }
    }

    private void renderRelations(Set<Node> packageMemberNodes, ClassDiagramResult classDiagramResult, StringBuilder builder) {
        for (Relationship relationship : classDiagramResult.getRelations()) {
            String arrowType = this.relationTypes.getOrDefault(relationship.getType(), DEFAULT_RELATION_TYPE);
            Node startNode = relationship.getStartNode();
            Node endNode = relationship.getEndNode();
            if (!packageMemberNodes.contains(startNode) || !packageMemberNodes.contains(endNode)) continue;
            builder.append(this.getNodeId(startNode)).append(arrowType).append(this.getNodeId(endNode)).append("\n");
        }
    }

    private String getType(TypeDescriptor type) {
        if (type instanceof InterfaceTypeDescriptor) {
            return "interface";
        }
        if (type instanceof EnumTypeDescriptor) {
            return "enum";
        }
        if (type instanceof AnnotationTypeDescriptor) {
            return "annotation";
        }
        return "class";
    }

    private void renderMemberSignature(MemberDescriptor member, int level, StringBuilder builder) {
        builder.append(this.indent(level));
        if (this.isStatic(member)) {
            builder.append("{static}").append(" ");
        }
        if (this.isAbstract((JavaByteCodeDescriptor)member)) {
            builder.append("{abstract}").append(" ");
        }
        builder.append(this.getVisibility((AccessModifierDescriptor)member));
        builder.append(member.getSignature()).append("\n");
    }

    private boolean isStatic(MemberDescriptor member) {
        return member.isStatic() != null && member.isStatic() != false;
    }

    private boolean isAbstract(JavaByteCodeDescriptor descriptor) {
        if (descriptor instanceof AbstractDescriptor) {
            AbstractDescriptor abstractDescriptor = (AbstractDescriptor)descriptor;
            return abstractDescriptor.isAbstract() != null ? abstractDescriptor.isAbstract() : false;
        }
        return false;
    }

    private String getVisibility(AccessModifierDescriptor accessModifierDescriptor) {
        if (accessModifierDescriptor.getVisibility() != null) {
            switch (accessModifierDescriptor.getVisibility()) {
                case "public": {
                    return "+";
                }
                case "private": {
                    return "-";
                }
                case "protected": {
                    return "#";
                }
                case "default": {
                    return "~";
                }
            }
        }
        return "";
    }
}

