/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.common.impl.scanner;

import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.plugin.common.api.model.ArchiveDescriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractContainerScannerPlugin;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.AbstractDirectoryResource;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.AbstractFileResource;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractArchiveInputStreamScannerPlugin<S extends ArchiveInputStream, E extends ArchiveEntry, D extends ArchiveDescriptor>
extends AbstractContainerScannerPlugin<S, E, D> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractArchiveInputStreamScannerPlugin.class);

    protected abstract E getNextEntry(S var1) throws IOException;

    public boolean accepts(S item, String path, Scope scope) throws IOException {
        return true;
    }

    @Override
    protected Iterable<? extends E> getEntries(S container) throws IOException {
        return new Iterable<E>((ArchiveInputStream)container){
            final /* synthetic */ ArchiveInputStream val$container;
            {
                this.val$container = archiveInputStream;
            }

            @Override
            public Iterator<E> iterator() {
                return new Iterator<E>(){
                    private E entry = null;

                    @Override
                    public boolean hasNext() {
                        if (this.entry == null) {
                            try {
                                this.entry = AbstractArchiveInputStreamScannerPlugin.this.getNextEntry(val$container);
                            }
                            catch (IOException e) {
                                LOGGER.warn("Cannot get next entry from archive.", (Throwable)e);
                            }
                            return this.entry != null;
                        }
                        return true;
                    }

                    @Override
                    public E next() {
                        Object next = this.entry;
                        this.entry = null;
                        return next;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    protected String getContainerPath(S container, String path) {
        return path;
    }

    @Override
    protected String getRelativePath(S container, E entry) {
        String name = entry.getName();
        if (entry.isDirectory()) {
            return "/" + name.substring(0, name.length() - 1);
        }
        return "/" + name;
    }

    @Override
    protected void enterContainer(S container, D containerDescriptor, ScannerContext scannerContext) throws IOException {
    }

    @Override
    protected void leaveContainer(S container, D containerDescriptor, ScannerContext scannerContext) throws IOException {
    }

    @Override
    protected Resource getEntry(S container, E entry) {
        if (entry.isDirectory()) {
            return new AbstractDirectoryResource(container.toString()){};
        }
        return new AbstractFileResource((ArchiveEntry)entry, (ArchiveInputStream)container){
            final /* synthetic */ ArchiveEntry val$entry;
            final /* synthetic */ ArchiveInputStream val$container;
            {
                this.val$entry = archiveEntry;
                this.val$container = archiveInputStream;
            }

            @Override
            public InputStream createStream() throws IOException {
                return new InputStream(){
                    int read = 0;

                    @Override
                    public int read() throws IOException {
                        if ((long)this.read < val$entry.getSize()) {
                            ++this.read;
                            return val$container.read();
                        }
                        return -1;
                    }
                };
            }
        };
    }
}

