/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.common.api.scanner;

import com.buschmais.jqassistant.plugin.common.api.model.DirectoryDescriptor;
import com.buschmais.jqassistant.plugin.common.api.model.FileContainerDescriptor;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.ContainerFileResolver;
import com.buschmais.jqassistant.plugin.common.test.AbstractPluginIT;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class ContainerFileResolverIT
extends AbstractPluginIT {
    @Test
    public void requireFile() {
        this.store.beginTransaction();
        DirectoryDescriptor container = (DirectoryDescriptor)this.store.create(DirectoryDescriptor.class);
        container.setFileName("/");
        ContainerFileResolver resolver = new ContainerFileResolver(this.getScanner().getContext(), (FileContainerDescriptor)container);
        FileDescriptor required1 = resolver.require("/file", FileDescriptor.class, this.getScanner().getContext());
        Assertions.assertThat((String)required1.getFileName()).isEqualTo("/file");
        FileDescriptor required2 = resolver.require("/file", FileDescriptor.class, this.getScanner().getContext());
        Assertions.assertThat((Object)required2).isSameAs((Object)required1);
        resolver.flush();
        this.store.commitTransaction();
    }

    @Test
    public void nestedContainer() {
        this.store.beginTransaction();
        DirectoryDescriptor parent = (DirectoryDescriptor)this.store.create(DirectoryDescriptor.class);
        parent.setFileName("/parentContainer");
        ContainerFileResolver parentResolver = new ContainerFileResolver(this.getScanner().getContext(), (FileContainerDescriptor)parent);
        FileDescriptor parentFile = parentResolver.require("/file", FileDescriptor.class, this.getScanner().getContext());
        Assertions.assertThat((String)parentFile.getFileName()).isEqualTo("/file");
        DirectoryDescriptor child = (DirectoryDescriptor)parentResolver.require("/childContainer", DirectoryDescriptor.class, this.getScanner().getContext());
        Assertions.assertThat((String)child.getFileName()).isEqualTo("/childContainer");
        ContainerFileResolver childResolver = new ContainerFileResolver(this.getScanner().getContext(), (FileContainerDescriptor)child);
        FileDescriptor childFile = childResolver.require("/file", FileDescriptor.class, this.getScanner().getContext());
        Assertions.assertThat((Object)parentFile).isNotSameAs((Object)childFile);
        childResolver.flush();
        parentResolver.flush();
        this.store.commitTransaction();
    }
}

