/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.common.impl.report;

import com.buschmais.jqassistant.core.report.api.ReportContext;
import com.buschmais.jqassistant.core.report.api.ReportException;
import com.buschmais.jqassistant.core.report.api.ReportPlugin;
import com.buschmais.jqassistant.core.report.api.model.Result;
import com.buschmais.jqassistant.core.report.impl.ReportContextImpl;
import com.buschmais.jqassistant.core.rule.api.model.Concept;
import com.buschmais.jqassistant.core.rule.api.model.Constraint;
import com.buschmais.jqassistant.core.rule.api.model.ExecutableRule;
import com.buschmais.jqassistant.core.store.api.Store;
import java.io.File;
import org.junit.jupiter.api.BeforeEach;
import org.mockito.Mock;

public abstract class AbstractReportPluginTest {
    protected final ReportPlugin plugin;
    @Mock
    protected Store store;
    protected ReportContext reportContext;

    protected AbstractReportPluginTest(ReportPlugin plugin) {
        this.plugin = plugin;
    }

    @BeforeEach
    public final void setUp() throws ReportException {
        this.plugin.initialize();
        File outputDirectory = new File("target/test");
        this.reportContext = new ReportContextImpl(this.store, outputDirectory);
    }

    protected final void apply(Constraint constraint, Result.Status status) throws ReportException {
        this.plugin.beginConstraint(constraint);
        this.plugin.setResult(this.getResult(constraint, status));
        this.plugin.endConstraint();
    }

    protected final void apply(Concept concept, Result.Status status) throws ReportException {
        this.plugin.beginConcept(concept);
        this.plugin.setResult(this.getResult(concept, status));
        this.plugin.endConcept();
    }

    protected abstract <T extends ExecutableRule<?>> Result<T> getResult(T var1, Result.Status var2);
}

