/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.common.impl.report;

import com.buschmais.jqassistant.core.report.api.ReportContext;
import com.buschmais.jqassistant.core.report.api.ReportException;
import com.buschmais.jqassistant.core.report.api.ReportPlugin;
import com.buschmais.jqassistant.core.report.api.model.Result;
import com.buschmais.jqassistant.core.rule.api.model.Concept;
import com.buschmais.jqassistant.core.rule.api.model.ExecutableRule;
import com.buschmais.jqassistant.core.rule.api.model.Severity;
import com.buschmais.jqassistant.plugin.common.api.model.NamedDescriptor;
import com.buschmais.jqassistant.plugin.common.impl.report.AbstractReportPluginTest;
import com.buschmais.jqassistant.plugin.common.impl.report.CSVReportPlugin;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class CSVReportPluginTest
extends AbstractReportPluginTest {
    private Concept conceptWithRows = (Concept)((Concept.ConceptBuilder)((Concept.ConceptBuilder)((Concept.ConceptBuilder)Concept.builder().id("test:ConceptWithRows")).description("testConceptWithRows")).severity(Severity.MINOR)).build();
    private Concept conceptWithoutRows = (Concept)((Concept.ConceptBuilder)((Concept.ConceptBuilder)((Concept.ConceptBuilder)Concept.builder().id("test:ConceptWithoutRows")).description("testConceptWithoutRows")).severity(Severity.MINOR)).build();

    public CSVReportPluginTest() {
        super((ReportPlugin)new CSVReportPlugin());
    }

    @Test
    public void conceptWithRows() throws ReportException, IOException {
        Map properties = Collections.emptyMap();
        this.plugin.configure(this.reportContext, properties);
        this.plugin.begin();
        this.apply(this.conceptWithRows, Result.Status.SUCCESS);
        this.plugin.end();
        File csvReportDirectory = this.reportContext.getReportDirectory("csv");
        MatcherAssert.assertThat((Object)csvReportDirectory.exists(), (Matcher)CoreMatchers.equalTo((Object)true));
        File reportFile = new File(csvReportDirectory, "test_ConceptWithRows.csv");
        MatcherAssert.assertThat((Object)reportFile.exists(), (Matcher)CoreMatchers.equalTo((Object)true));
        List reports = this.reportContext.getReports((ExecutableRule)this.conceptWithRows);
        MatcherAssert.assertThat((Object)reports.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        ReportContext.Report report = (ReportContext.Report)reports.get(0);
        MatcherAssert.assertThat((Object)report.getRule(), (Matcher)CoreMatchers.is((Object)this.conceptWithRows));
        MatcherAssert.assertThat((Object)report.getLabel(), (Matcher)CoreMatchers.equalTo((Object)"CSV"));
        MatcherAssert.assertThat((Object)report.getReportType(), (Matcher)CoreMatchers.equalTo((Object)ReportContext.ReportType.LINK));
        MatcherAssert.assertThat((Object)report.getUrl(), (Matcher)CoreMatchers.equalTo((Object)reportFile.toURI().toURL()));
        String content = FileUtils.readFileToString((File)reportFile);
        MatcherAssert.assertThat((Object)content, (Matcher)CoreMatchers.equalTo((Object)"\"String\",\"Double\",\"Named\",\"EscapedString\"\n\"foo\",\"42.0\",\"Test\",\"\"\"'\"\n"));
    }

    @Test
    public void separatorAndEscapeChar() throws ReportException, IOException {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("csv.report.separator", ";");
        properties.put("csv.report.quoteChar", "'");
        properties.put("csv.report.escapeChar", "'");
        this.plugin.configure(this.reportContext, properties);
        this.plugin.begin();
        this.apply(this.conceptWithRows, Result.Status.SUCCESS);
        this.plugin.end();
        File csvReportDirectory = this.reportContext.getReportDirectory("csv");
        MatcherAssert.assertThat((Object)csvReportDirectory.exists(), (Matcher)CoreMatchers.equalTo((Object)true));
        File report = new File(csvReportDirectory, "test_ConceptWithRows.csv");
        MatcherAssert.assertThat((Object)report.exists(), (Matcher)CoreMatchers.equalTo((Object)true));
        String content = FileUtils.readFileToString((File)report);
        MatcherAssert.assertThat((Object)content, (Matcher)CoreMatchers.equalTo((Object)"'String';'Double';'Named';'EscapedString'\n'foo';'42.0';'Test';'\"'''\n"));
    }

    @Test
    public void conceptWithoutRows() throws ReportException, IOException {
        Map properties = Collections.emptyMap();
        this.plugin.configure(this.reportContext, properties);
        this.plugin.begin();
        this.apply(this.conceptWithoutRows, Result.Status.SUCCESS);
        this.plugin.end();
        File csvReportDirectory = this.reportContext.getReportDirectory("csv");
        MatcherAssert.assertThat((Object)csvReportDirectory.exists(), (Matcher)CoreMatchers.equalTo((Object)true));
        File report = new File(csvReportDirectory, "test_ConceptWithoutRows.csv");
        MatcherAssert.assertThat((Object)report.exists(), (Matcher)CoreMatchers.equalTo((Object)true));
        String content = FileUtils.readFileToString((File)report);
        MatcherAssert.assertThat((Object)content, (Matcher)CoreMatchers.equalTo((Object)""));
    }

    @Override
    protected <T extends ExecutableRule<?>> Result<T> getResult(T rule, Result.Status status) {
        if (rule.equals(this.conceptWithRows)) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            row.put("String", "foo");
            row.put("Double", 42.0);
            row.put("Named", new NamedDescriptor(){

                public <I> I getId() {
                    return null;
                }

                public <T> T as(Class<T> type) {
                    return null;
                }

                public <D> D getDelegate() {
                    return null;
                }

                public String getName() {
                    return "Test";
                }

                public void setName(String name) {
                }
            });
            row.put("EscapedString", "\"'");
            return Result.builder().rule(rule).severity(rule.getSeverity()).status(status).columnNames(Arrays.asList("String", "Double", "Named", "EscapedString")).rows(Arrays.asList(row)).build();
        }
        return Result.builder().rule(rule).severity(rule.getSeverity()).status(status).columnNames(null).rows(null).build();
    }
}

