/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.common.impl.report;

import com.buschmais.jqassistant.core.report.api.ReportException;
import com.buschmais.jqassistant.core.report.api.ReportPlugin;
import com.buschmais.jqassistant.core.report.api.model.Result;
import com.buschmais.jqassistant.core.rule.api.model.Concept;
import com.buschmais.jqassistant.core.rule.api.model.Constraint;
import com.buschmais.jqassistant.core.rule.api.model.ExecutableRule;
import com.buschmais.jqassistant.core.rule.api.model.Group;
import com.buschmais.jqassistant.core.rule.api.model.Severity;
import com.buschmais.jqassistant.core.shared.xml.JAXBUnmarshaller;
import com.buschmais.jqassistant.plugin.common.impl.report.AbstractReportPluginTest;
import com.buschmais.jqassistant.plugin.common.impl.report.JUnitReportPlugin;
import com.buschmais.jqassistant.plugin.junit.impl.schema.Error;
import com.buschmais.jqassistant.plugin.junit.impl.schema.Failure;
import com.buschmais.jqassistant.plugin.junit.impl.schema.Testcase;
import com.buschmais.jqassistant.plugin.junit.impl.schema.Testsuite;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class JUnitReportPluginTest
extends AbstractReportPluginTest {
    private static final String EXPECTED_CONTENT = "c = foo\n---\nc = bar\n";
    private JAXBUnmarshaller<Testsuite> unmarshaller = new JAXBUnmarshaller(Testsuite.class);
    private Group testGroup = (Group)((Group.GroupBuilder)((Group.GroupBuilder)Group.builder().id("test:Group")).description("testGroup")).build();
    private Concept concept = (Concept)((Concept.ConceptBuilder)((Concept.ConceptBuilder)((Concept.ConceptBuilder)Concept.builder().id("test:Concept")).description("testConcept")).severity(Severity.MINOR)).build();
    private Concept majorConcept = (Concept)((Concept.ConceptBuilder)((Concept.ConceptBuilder)((Concept.ConceptBuilder)Concept.builder().id("test:MajorConcept")).description("testMajorConcept")).severity(Severity.MAJOR)).build();
    private Concept blockerConcept = (Concept)((Concept.ConceptBuilder)((Concept.ConceptBuilder)((Concept.ConceptBuilder)Concept.builder().id("test:BlockerConcept")).description("testBlockerConcept")).severity(Severity.BLOCKER)).build();
    private Concept criticalConcept = (Concept)((Concept.ConceptBuilder)((Concept.ConceptBuilder)((Concept.ConceptBuilder)Concept.builder().id("test:CriticalConcept")).description("testCriticalConcept")).severity(Severity.CRITICAL)).build();
    private Constraint constraint = (Constraint)((Constraint.ConstraintBuilder)((Constraint.ConstraintBuilder)((Constraint.ConstraintBuilder)Constraint.builder().id("test:Constraint")).description("testConstraint")).severity(Severity.MINOR)).build();
    private Constraint majorConstraint = (Constraint)((Constraint.ConstraintBuilder)((Constraint.ConstraintBuilder)((Constraint.ConstraintBuilder)Constraint.builder().id("test:MajorConstraint")).description("testMajorConstraint")).severity(Severity.MAJOR)).build();
    private Constraint blockerConstraint = (Constraint)((Constraint.ConstraintBuilder)((Constraint.ConstraintBuilder)((Constraint.ConstraintBuilder)Constraint.builder().id("test:BlockerConstraint")).description("testBlockerConstraint")).severity(Severity.BLOCKER)).build();
    private Constraint criticalConstraint = (Constraint)((Constraint.ConstraintBuilder)((Constraint.ConstraintBuilder)((Constraint.ConstraintBuilder)Constraint.builder().id("test:CriticalConstraint")).description("testCriticalConstraint")).severity(Severity.CRITICAL)).build();

    public JUnitReportPluginTest() {
        super((ReportPlugin)new JUnitReportPlugin());
    }

    @Test
    public void junitReport() throws ReportException, IOException {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("junit.report.failureSeverity", Severity.BLOCKER.name());
        properties.put("junit.report.errorSeverity", Severity.CRITICAL.name());
        this.plugin.configure(this.reportContext, properties);
        this.plugin.begin();
        this.apply(this.concept, Result.Status.SUCCESS);
        this.apply(this.constraint, Result.Status.SUCCESS);
        this.plugin.beginGroup(this.testGroup);
        this.apply(this.majorConcept, Result.Status.FAILURE);
        this.apply(this.blockerConcept, Result.Status.FAILURE);
        this.apply(this.criticalConcept, Result.Status.FAILURE);
        this.apply(this.majorConstraint, Result.Status.FAILURE);
        this.apply(this.blockerConstraint, Result.Status.FAILURE);
        this.apply(this.criticalConstraint, Result.Status.FAILURE);
        this.plugin.endGroup();
        this.plugin.end();
        File junitReportDirectory = this.reportContext.getReportDirectory("junit");
        MatcherAssert.assertThat((Object)junitReportDirectory.exists(), (Matcher)CoreMatchers.equalTo((Object)true));
        Testsuite rootTestSuite = this.getTestsuite(junitReportDirectory, "TEST-jqassistant.Group.xml");
        this.verifyTestSuite(rootTestSuite, 2, 0, 0);
        Map<String, Testcase> rootTestCases = this.getTestCases(rootTestSuite);
        this.verifyTestCaseSuccess(rootTestCases.get("Concept_test_Concept"), "jqassistant.Group");
        this.verifyTestCaseSuccess(rootTestCases.get("Constraint_test_Constraint"), "jqassistant.Group");
        Testsuite groupTestSuite = this.getTestsuite(junitReportDirectory, "TEST-jqassistant.Group_test_Group.xml");
        this.verifyTestSuite(groupTestSuite, 6, 2, 2);
        Map<String, Testcase> groupTestCases = this.getTestCases(groupTestSuite);
        this.verifyTestCaseSuccess(groupTestCases.get("Concept_test_MajorConcept"), "jqassistant.Group_test_Group");
        this.verifyTestCaseFailure(groupTestCases.get("Concept_test_BlockerConcept"), "jqassistant.Group_test_Group", "testBlockerConcept");
        this.verifyTestCaseError(groupTestCases.get("Concept_test_CriticalConcept"), "jqassistant.Group_test_Group", "testCriticalConcept");
        this.verifyTestCaseSuccess(groupTestCases.get("Constraint_test_MajorConstraint"), "jqassistant.Group_test_Group");
        this.verifyTestCaseFailure(groupTestCases.get("Constraint_test_BlockerConstraint"), "jqassistant.Group_test_Group", "testBlockerConstraint");
        this.verifyTestCaseError(groupTestCases.get("Constraint_test_CriticalConstraint"), "jqassistant.Group_test_Group", "testCriticalConstraint");
    }

    private Map<String, Testcase> getTestCases(Testsuite rootTestSuite) {
        return rootTestSuite.getTestcase().stream().collect(Collectors.toMap(testCase -> testCase.getName(), testCase -> testCase));
    }

    private void verifyTestSuite(Testsuite testSuite, int expectedTests, int expectedFailures, int expectedErrors) {
        MatcherAssert.assertThat((Object)testSuite.getTests(), (Matcher)CoreMatchers.equalTo((Object)Integer.toString(expectedTests)));
        MatcherAssert.assertThat((Object)testSuite.getFailures(), (Matcher)CoreMatchers.equalTo((Object)Integer.toString(expectedFailures)));
        MatcherAssert.assertThat((Object)testSuite.getErrors(), (Matcher)CoreMatchers.equalTo((Object)Integer.toString(expectedErrors)));
        MatcherAssert.assertThat((Object)testSuite.getTestcase().size(), (Matcher)CoreMatchers.equalTo((Object)expectedTests));
        MatcherAssert.assertThat((Object)Double.valueOf(testSuite.getTime()), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Double.valueOf(0.0)));
    }

    private Testsuite getTestsuite(File junitReportDirectory, String fileName) throws IOException {
        File report = new File(junitReportDirectory, fileName);
        MatcherAssert.assertThat((Object)report.exists(), (Matcher)CoreMatchers.equalTo((Object)true));
        return (Testsuite)this.unmarshaller.unmarshal((InputStream)new FileInputStream(report));
    }

    private void verifyTestCaseSuccess(Testcase testCase, String expectedClassName) {
        this.verifyTestCase(testCase, expectedClassName);
        MatcherAssert.assertThat((Object)testCase.getFailure().size(), (Matcher)CoreMatchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)testCase.getError().size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    private void verifyTestCaseFailure(Testcase testCase, String expectedClassName, String expectedMessage) {
        this.verifyTestCase(testCase, expectedClassName);
        List failures = testCase.getFailure();
        MatcherAssert.assertThat((Object)failures.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)testCase.getError().size(), (Matcher)CoreMatchers.equalTo((Object)0));
        Failure failure = (Failure)failures.get(0);
        MatcherAssert.assertThat((Object)failure.getMessage(), (Matcher)CoreMatchers.equalTo((Object)expectedMessage));
        MatcherAssert.assertThat((Object)failure.getContent(), (Matcher)CoreMatchers.equalTo((Object)EXPECTED_CONTENT));
    }

    private void verifyTestCaseError(Testcase testCase, String expectedClassName, String expectedMessage) {
        this.verifyTestCase(testCase, expectedClassName);
        MatcherAssert.assertThat((Object)testCase.getFailure().size(), (Matcher)CoreMatchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)testCase.getError().size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Error error = (Error)testCase.getError().get(0);
        MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)CoreMatchers.equalTo((Object)expectedMessage));
        MatcherAssert.assertThat((Object)error.getContent(), (Matcher)CoreMatchers.equalTo((Object)EXPECTED_CONTENT));
    }

    private void verifyTestCase(Testcase testCase, String expectedClassName) {
        MatcherAssert.assertThat((Object)testCase, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)testCase.getClassname(), (Matcher)CoreMatchers.equalTo((Object)expectedClassName));
        MatcherAssert.assertThat((Object)Double.valueOf(testCase.getTime()), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Double.valueOf(0.0)));
    }

    @Override
    protected <T extends ExecutableRule<?>> Result<T> getResult(T rule, Result.Status status) {
        HashMap<String, String> row1 = new HashMap<String, String>();
        row1.put("c", "foo");
        HashMap<String, String> row2 = new HashMap<String, String>();
        row2.put("c", "bar");
        return Result.builder().rule(rule).severity(rule.getSeverity()).status(status).columnNames(Arrays.asList("c")).rows(Arrays.asList(row1, row2)).build();
    }
}

