/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.common.impl.rule;

import com.buschmais.jqassistant.core.analysis.api.AnalyzerContext;
import com.buschmais.jqassistant.core.report.api.model.Result;
import com.buschmais.jqassistant.core.rule.api.model.Concept;
import com.buschmais.jqassistant.core.rule.api.model.Executable;
import com.buschmais.jqassistant.core.rule.api.model.ExecutableRule;
import com.buschmais.jqassistant.core.rule.api.model.RuleException;
import com.buschmais.jqassistant.core.rule.api.model.Severity;
import com.buschmais.jqassistant.core.rule.impl.SourceExecutable;
import com.buschmais.jqassistant.plugin.common.api.rule.JavaRule;
import com.buschmais.jqassistant.plugin.common.impl.rule.YamlRuleInterpreterPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class YamlRuleInterpreterPluginTest {
    @Mock
    private AnalyzerContext analyzerContext;
    private YamlRuleInterpreterPlugin plugin = new YamlRuleInterpreterPlugin();

    @BeforeEach
    public void setUp() {
        ((AnalyzerContext)Mockito.doAnswer(invocation -> {
            ExecutableRule rule = (ExecutableRule)invocation.getArguments()[0];
            Severity severity = (Severity)invocation.getArguments()[1];
            return Result.builder().rule(rule).severity(severity);
        }).when((Object)this.analyzerContext)).resultBuilder((ExecutableRule)Matchers.any(ExecutableRule.class), (Severity)Matchers.any(Severity.class));
        this.plugin.initialize();
        this.plugin.configure(Collections.emptyMap());
    }

    @Test
    public void javaRule() throws RuleException {
        String source = "java-rule: " + TestJavaRule.class.getName() + "\nconfiguration:\n  testProperty: testValue";
        SourceExecutable executable = new SourceExecutable("yaml", (Object)source, String.class);
        Concept concept = (Concept)((Concept.ConceptBuilder)((Concept.ConceptBuilder)((Concept.ConceptBuilder)Concept.builder().id("test-java-rule")).executable((Executable)executable)).severity(Severity.MINOR)).build();
        Result result = this.plugin.execute((ExecutableRule)concept, Collections.emptyMap(), Severity.MAJOR, this.analyzerContext);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)result.getRule(), (Matcher)CoreMatchers.is((Object)concept));
        MatcherAssert.assertThat((Object)result.getSeverity(), (Matcher)CoreMatchers.is((Object)Severity.MAJOR));
        MatcherAssert.assertThat((Object)result.getStatus(), (Matcher)CoreMatchers.equalTo((Object)Result.Status.SUCCESS));
        MatcherAssert.assertThat((Object)result.getColumnNames(), (Matcher)CoreMatchers.equalTo(Arrays.asList("Property", "Value")));
        List rows = result.getRows();
        MatcherAssert.assertThat((Object)rows.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Map row = (Map)rows.get(0);
        MatcherAssert.assertThat(row.get("Property"), (Matcher)CoreMatchers.equalTo((Object)"testProperty"));
        MatcherAssert.assertThat(row.get("Value"), (Matcher)CoreMatchers.equalTo((Object)"testValue"));
    }

    public static class TestJavaRule
    implements JavaRule {
        public <T extends ExecutableRule<?>> Result<T> execute(T executableRule, Map<String, Object> configuration, Map<String, Object> ruleParameters, Severity severity, AnalyzerContext context) {
            ArrayList rows = new ArrayList();
            for (Map.Entry<String, Object> entry : configuration.entrySet()) {
                HashMap<String, Object> row = new HashMap<String, Object>();
                row.put("Property", entry.getKey());
                row.put("Value", entry.getValue());
                rows.add(row);
            }
            return context.resultBuilder(executableRule, severity).status(Result.Status.SUCCESS).columnNames(Arrays.asList("Property", "Value")).rows(rows).build();
        }
    }
}

