/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.common.test;

import com.buschmais.jqassistant.core.analysis.api.Analyzer;
import com.buschmais.jqassistant.core.analysis.api.AnalyzerConfiguration;
import com.buschmais.jqassistant.core.analysis.api.RuleInterpreterPlugin;
import com.buschmais.jqassistant.core.analysis.impl.AnalyzerImpl;
import com.buschmais.jqassistant.core.plugin.api.PluginConfigurationReader;
import com.buschmais.jqassistant.core.plugin.impl.PluginConfigurationReaderImpl;
import com.buschmais.jqassistant.core.plugin.impl.PluginRepositoryImpl;
import com.buschmais.jqassistant.core.report.api.ReportContext;
import com.buschmais.jqassistant.core.report.api.ReportPlugin;
import com.buschmais.jqassistant.core.report.api.model.Result;
import com.buschmais.jqassistant.core.report.impl.CompositeReportPlugin;
import com.buschmais.jqassistant.core.report.impl.InMemoryReportPlugin;
import com.buschmais.jqassistant.core.report.impl.ReportContextImpl;
import com.buschmais.jqassistant.core.rule.api.model.Concept;
import com.buschmais.jqassistant.core.rule.api.model.Constraint;
import com.buschmais.jqassistant.core.rule.api.model.Group;
import com.buschmais.jqassistant.core.rule.api.model.RuleException;
import com.buschmais.jqassistant.core.rule.api.model.RuleSelection;
import com.buschmais.jqassistant.core.rule.api.model.RuleSet;
import com.buschmais.jqassistant.core.rule.api.reader.RuleConfiguration;
import com.buschmais.jqassistant.core.rule.api.source.FileRuleSource;
import com.buschmais.jqassistant.core.rule.impl.reader.RuleParser;
import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.ScannerConfiguration;
import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.scanner.impl.ScannerContextImpl;
import com.buschmais.jqassistant.core.scanner.impl.ScannerImpl;
import com.buschmais.jqassistant.core.scanner.spi.ScannerPluginRepository;
import com.buschmais.jqassistant.core.shared.annotation.ToBeRemovedInVersion;
import com.buschmais.jqassistant.core.shared.io.ClasspathResource;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.api.StoreConfiguration;
import com.buschmais.jqassistant.core.store.api.StoreFactory;
import com.buschmais.jqassistant.core.store.spi.StorePluginRepository;
import com.buschmais.jqassistant.neo4j.backend.bootstrap.EmbeddedNeo4jConfiguration;
import com.buschmais.xo.api.Query;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPluginIT {
    protected static final String ARTIFACT_ID = "artifact";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPluginIT.class);
    private static PluginRepositoryImpl pluginRepository;
    private File outputDirectory;
    protected Store store;
    protected Analyzer analyzer;
    protected ReportContext reportContext;
    protected InMemoryReportPlugin reportPlugin;
    protected RuleSet ruleSet;

    @BeforeAll
    public static void initPluginRepository() {
        ClassLoader pluginClassLoader = AbstractPluginIT.class.getClassLoader();
        PluginConfigurationReaderImpl pluginConfigurationReader = new PluginConfigurationReaderImpl(pluginClassLoader);
        pluginRepository = new PluginRepositoryImpl((PluginConfigurationReader)pluginConfigurationReader);
        pluginRepository.initialize();
    }

    @AfterAll
    public static void destroyPluginRepository() {
        if (pluginRepository != null) {
            pluginRepository.destroy();
        }
    }

    @BeforeEach
    public void beforeEach(TestInfo testInfo) throws Exception {
        this.initializeRuleSet();
        this.outputDirectory = new File("target/jqassistant");
        this.outputDirectory.mkdirs();
        this.startStore(testInfo);
        this.initializeAnalyzer();
    }

    @AfterEach
    public void stopStore() {
        if (this.store != null) {
            this.store.stop();
        }
    }

    private void initializeRuleSet() throws RuleException, IOException {
        File selectedDirectory = new File(this.getClassesDirectory(this.getClass()), "rules");
        LinkedList sources = new LinkedList();
        if (selectedDirectory.exists()) {
            sources.addAll(FileRuleSource.getRuleSources((File)selectedDirectory));
        }
        sources.addAll(pluginRepository.getRulePluginRepository().getRuleSources());
        Collection ruleParserPlugins = pluginRepository.getRulePluginRepository().getRuleParserPlugins(RuleConfiguration.DEFAULT);
        RuleParser ruleParser = new RuleParser(ruleParserPlugins);
        this.ruleSet = ruleParser.parse(sources);
    }

    private void initializeAnalyzer() {
        this.reportContext = new ReportContextImpl(this.store, this.outputDirectory);
        this.reportPlugin = new InMemoryReportPlugin((ReportPlugin)new CompositeReportPlugin(this.getReportPlugins(this.getReportProperties())));
        AnalyzerConfiguration configuration = this.getAnalyzerConfiguration();
        this.analyzer = new AnalyzerImpl(configuration, this.store, this.getRuleInterpreterPlugins(), (ReportPlugin)this.reportPlugin, LOGGER);
    }

    protected Map<String, Object> getScannerProperties() {
        return Collections.emptyMap();
    }

    protected AnalyzerConfiguration getAnalyzerConfiguration() {
        return new AnalyzerConfiguration();
    }

    protected Map<String, Object> getReportProperties() {
        return Collections.emptyMap();
    }

    protected Map<String, Collection<RuleInterpreterPlugin>> getRuleInterpreterPlugins() {
        return pluginRepository.getAnalyzerPluginRepository().getRuleInterpreterPlugins(this.getRuleInterpreterProperties());
    }

    protected Map<String, Object> getRuleInterpreterProperties() {
        return Collections.emptyMap();
    }

    private void startStore(TestInfo testInfo) throws URISyntaxException {
        Method method = (Method)testInfo.getTestMethod().orElseThrow(() -> new AssertionError((Object)("Unabled to get the test method for test '" + testInfo.getDisplayName() + "'.")));
        TestStore testStore = method.getAnnotation(TestStore.class);
        TestStore.Type type = testStore != null ? testStore.type() : TestStore.Type.MEMORY;
        StoreConfiguration.StoreConfigurationBuilder storeConfigurationBuilder = StoreConfiguration.builder();
        switch (type) {
            case FILE: {
                String fileName = "target/jqassistant/test-store";
                storeConfigurationBuilder.uri(new File(fileName).toURI());
                storeConfigurationBuilder.embedded(this.getEmbeddedNeo4jConfiguration());
                break;
            }
            case MEMORY: {
                storeConfigurationBuilder.uri(new URI("memory:///"));
                storeConfigurationBuilder.embedded(this.getEmbeddedNeo4jConfiguration());
                break;
            }
            case REMOTE: {
                storeConfigurationBuilder.uri(new URI("bolt://localhost:7687"));
                storeConfigurationBuilder.encryption("NONE");
                storeConfigurationBuilder.username("neo4j").password("jqassistant");
                Properties properties = new Properties();
                properties.put("neo4j.remote.statement.log.level", "info");
                storeConfigurationBuilder.properties(properties);
                break;
            }
            default: {
                throw new AssertionError((Object)("Test store type not supported: " + (Object)((Object)type)));
            }
        }
        StoreConfiguration configuration = storeConfigurationBuilder.build();
        this.store = StoreFactory.getStore((StoreConfiguration)configuration, (StorePluginRepository)pluginRepository.getStorePluginRepository());
        this.store.start();
        if (testStore == null || testStore.reset()) {
            this.store.reset();
        }
    }

    protected EmbeddedNeo4jConfiguration getEmbeddedNeo4jConfiguration() {
        return EmbeddedNeo4jConfiguration.builder().build();
    }

    protected Scanner getScanner() {
        return this.getScanner(this.getScannerProperties());
    }

    protected Scanner getScanner(Map<String, Object> properties) {
        ScannerContextImpl scannerContext = new ScannerContextImpl(this.store, this.outputDirectory);
        ScannerPluginRepository scannerPluginRepository = pluginRepository.getScannerPluginRepository();
        return new ScannerImpl(this.getScannerConfiguration(), properties, (ScannerContext)scannerContext, scannerPluginRepository);
    }

    protected ScannerConfiguration getScannerConfiguration() {
        return new ScannerConfiguration();
    }

    protected File getClassesDirectory(Class<?> rootClass) {
        File directory = ClasspathResource.getFile(rootClass, (String)"/");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)directory.isDirectory()).describedAs("Expected %s to be a directory", new Object[]{directory.toString()})).isTrue();
        return directory;
    }

    protected void removeTestClass() {
        this.store.beginTransaction();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("className", this.getClass().getName());
        this.store.executeQuery("MATCH (t:Type)-[r]-() WHERE t.fqn=$className DELETE r", parameters).close();
        this.store.executeQuery("MATCH (t:Type) WHERE t.fqn=$className DELETE t", parameters).close();
        this.store.commitTransaction();
    }

    protected TestResult query(String query) {
        return this.query(query, Collections.emptyMap());
    }

    protected TestResult query(String query, Map<String, Object> parameters) {
        Query.Result compositeRowObjects = this.store.executeQuery(query, parameters);
        ArrayList rows = new ArrayList();
        HashMap columns = new HashMap();
        for (Query.Result.CompositeRowObject rowObject : compositeRowObjects) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            List columnNames = rowObject.getColumns();
            for (String columnName : columnNames) {
                ArrayList<Object> columnValues = (ArrayList<Object>)columns.get(columnName);
                if (columnValues == null) {
                    columnValues = new ArrayList<Object>();
                    columns.put(columnName, columnValues);
                }
                Object value = rowObject.get(columnName, Object.class);
                row.put(columnName, value);
                columnValues.add(value);
            }
            rows.add(row);
        }
        return new TestResult(rows, columns);
    }

    protected Result<Concept> applyConcept(String id) throws RuleException {
        return this.applyConcept(id, Collections.emptyMap());
    }

    protected Result<Concept> applyConcept(String id, Map<String, String> parameters) throws RuleException {
        RuleSelection ruleSelection = RuleSelection.builder().conceptId(id).build();
        Concept concept = (Concept)this.ruleSet.getConceptBucket().getById(id);
        ((ObjectAssert)Assertions.assertThat((Object)concept).describedAs("The requested concept cannot be found: " + id, new Object[0])).isNotNull();
        this.analyzer.execute(this.ruleSet, ruleSelection, parameters);
        return (Result)this.reportPlugin.getConceptResults().get(id);
    }

    protected Result<Constraint> validateConstraint(String id) throws RuleException {
        return this.validateConstraint(id, Collections.emptyMap());
    }

    protected Result<Constraint> validateConstraint(String id, Map<String, String> parameters) throws RuleException {
        RuleSelection ruleSelection = RuleSelection.builder().constraintId(id).build();
        Constraint constraint = (Constraint)this.ruleSet.getConstraintBucket().getById(id);
        ((ObjectAssert)Assertions.assertThat((Object)constraint).describedAs("The requested constraint cannot be found: " + id, new Object[0])).isNotNull();
        this.analyzer.execute(this.ruleSet, ruleSelection, parameters);
        return (Result)this.reportPlugin.getConstraintResults().get(id);
    }

    protected void executeGroup(String id) throws RuleException {
        this.executeGroup(id, Collections.emptyMap());
    }

    protected void executeGroup(String id, Map<String, String> parameters) throws RuleException {
        RuleSelection ruleSelection = RuleSelection.builder().groupId(id).build();
        Group group = (Group)this.ruleSet.getGroupsBucket().getById(id);
        ((ObjectAssert)Assertions.assertThat((Object)group).describedAs("The request group cannot be found: " + id, new Object[0])).isNotNull();
        this.analyzer.execute(this.ruleSet, ruleSelection, parameters);
    }

    @Deprecated
    @ToBeRemovedInVersion(major=1, minor=11)
    protected Map<String, ReportPlugin> getReportPlugins(Map<String, Object> properties) {
        return this.getReportPlugins(this.reportContext, properties);
    }

    @Deprecated
    @ToBeRemovedInVersion(major=1, minor=11)
    protected Map<String, ReportPlugin> getReportPlugins(ReportContext reportContext, Map<String, Object> properties) {
        return pluginRepository.getAnalyzerPluginRepository().getReportPlugins(reportContext, properties);
    }

    protected class TestResult {
        private List<Map<String, Object>> rows;
        private Map<String, List<Object>> columns;

        public <T> List<T> getColumn(String name) {
            List<Object> column = this.columns.get(name);
            if (column == null) {
                throw new IllegalArgumentException("The result does not contain a column '" + name + "'.");
            }
            return column;
        }

        public List<Map<String, Object>> getRows() {
            return this.rows;
        }

        public Map<String, List<Object>> getColumns() {
            return this.columns;
        }

        private TestResult(List<Map<String, Object>> rows, Map<String, List<Object>> columns) {
            this.rows = rows;
            this.columns = columns;
        }

        public String toString() {
            return "AbstractPluginIT.TestResult(rows=" + this.getRows() + ", columns=" + this.getColumns() + ")";
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    protected static @interface TestStore {
        public boolean reset() default true;

        public Type type() default Type.FILE;

        public static enum Type {
            FILE,
            MEMORY,
            REMOTE;

        }
    }
}

