/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.common.test.rule;

import com.buschmais.jqassistant.core.report.api.model.Result;
import com.buschmais.jqassistant.core.rule.api.model.ExecutableRule;
import com.buschmais.jqassistant.core.rule.api.model.Severity;
import com.buschmais.jqassistant.plugin.common.test.AbstractPluginIT;
import com.buschmais.jqassistant.plugin.common.test.rule.model.TestLabelDescriptor;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class ScriptIT
extends AbstractPluginIT {
    @Test
    public void javaScriptXmlConcept() throws Exception {
        MatcherAssert.assertThat((Object)this.applyConcept("javascript:XmlTestConcept").getStatus(), (Matcher)Matchers.equalTo((Object)Result.Status.SUCCESS));
        this.verifyResults(this.reportPlugin.getConceptResults(), "javascript:XmlTestConcept", Severity.MAJOR);
    }

    @Test
    public void JavaScriptAsciiDocConcept() throws Exception {
        MatcherAssert.assertThat((Object)this.applyConcept("javascript:AsciiDocTestConcept").getStatus(), (Matcher)Matchers.equalTo((Object)Result.Status.SUCCESS));
        this.verifyResults(this.reportPlugin.getConceptResults(), "javascript:AsciiDocTestConcept", Severity.MAJOR);
    }

    @Test
    public void javaScriptXmlConstraint() throws Exception {
        MatcherAssert.assertThat((Object)this.validateConstraint("javascript:XmlTestConstraint").getStatus(), (Matcher)Matchers.equalTo((Object)Result.Status.SUCCESS));
        this.verifyResults(this.reportPlugin.getConstraintResults(), "javascript:XmlTestConstraint", Severity.BLOCKER);
    }

    @Test
    public void JavaScriptAsciiDocConstraint() throws Exception {
        MatcherAssert.assertThat((Object)this.validateConstraint("javascript:AsciiDocTestConstraint").getStatus(), (Matcher)Matchers.equalTo((Object)Result.Status.SUCCESS));
        this.verifyResults(this.reportPlugin.getConstraintResults(), "javascript:AsciiDocTestConstraint", Severity.BLOCKER);
    }

    @Test
    public void groovyXmlConcept() throws Exception {
        MatcherAssert.assertThat((Object)this.applyConcept("groovy:XmlTestConcept").getStatus(), (Matcher)Matchers.equalTo((Object)Result.Status.SUCCESS));
        this.verifyResults(this.reportPlugin.getConceptResults(), "groovy:XmlTestConcept", Severity.MAJOR);
    }

    @Test
    public void groovyXmlConstraint() throws Exception {
        MatcherAssert.assertThat((Object)this.validateConstraint("groovy:XmlTestConstraint").getStatus(), (Matcher)Matchers.equalTo((Object)Result.Status.SUCCESS));
        this.verifyResults(this.reportPlugin.getConstraintResults(), "groovy:XmlTestConstraint", Severity.BLOCKER);
    }

    @Test
    public void rubyXmlConcept() throws Exception {
        MatcherAssert.assertThat((Object)this.applyConcept("ruby:XmlTestConcept").getStatus(), (Matcher)Matchers.equalTo((Object)Result.Status.SUCCESS));
        this.verifyResults(this.reportPlugin.getConceptResults(), "ruby:XmlTestConcept", Severity.MAJOR);
    }

    @Test
    public void rubyXmlConstraint() throws Exception {
        MatcherAssert.assertThat((Object)this.validateConstraint("ruby:XmlTestConstraint").getStatus(), (Matcher)Matchers.equalTo((Object)Result.Status.FAILURE));
        this.verifyResults(this.reportPlugin.getConstraintResults(), "ruby:XmlTestConstraint", Severity.BLOCKER);
    }

    private <R extends ExecutableRule> void verifyResults(Map<String, Result<R>> results, String ruleName, Severity severity) {
        this.store.beginTransaction();
        MatcherAssert.assertThat((String)"Expecting one analysis result.", (Object)results.size(), (Matcher)Matchers.equalTo((Object)1));
        Result<R> result = results.get(ruleName);
        MatcherAssert.assertThat((String)("Expecting a result for " + ruleName), result, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((String)("Expecting severity " + severity), (Object)result.getSeverity(), (Matcher)Matchers.equalTo((Object)severity));
        List rows = result.getRows();
        MatcherAssert.assertThat((String)("Expecting one row for rule " + ruleName), (Object)rows.size(), (Matcher)Matchers.equalTo((Object)1));
        Map row = (Map)rows.get(0);
        Object value = row.get("test");
        MatcherAssert.assertThat((String)"Expecting a column test", value, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((String)("Expecting a value of type " + TestLabelDescriptor.class.getName()), value, (Matcher)Matchers.instanceOf(TestLabelDescriptor.class));
        TestLabelDescriptor testLabelDescriptor = (TestLabelDescriptor)value;
        MatcherAssert.assertThat((String)"Expecting property with value 'test'", (Object)testLabelDescriptor.getName(), (Matcher)Matchers.equalTo((Object)"test"));
        this.store.commitTransaction();
    }
}

