/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.common.test.scanner;

import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FileResource;
import com.buschmais.jqassistant.plugin.common.impl.scanner.BufferedFileResource;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Test;

public class BufferedFileResourceTest {
    private static final String stream = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";

    @Test
    public void reUseBuffer() throws IOException {
        this.readAndVerify(stream.length());
    }

    @Test
    public void exhaustBuffer() throws IOException {
        this.readAndVerify(5);
    }

    private void readAndVerify(int bufferSize) throws IOException {
        FileResource fileResource = this.getFileResource(stream);
        BufferedFileResource bufferedFileResource = new BufferedFileResource(fileResource, bufferSize);
        byte[] target = new byte[10];
        String expectedStream = stream.substring(0, 10);
        this.readAndVerify(bufferedFileResource, target, expectedStream);
        this.readAndVerify(bufferedFileResource, target, expectedStream);
    }

    private void readAndVerify(BufferedFileResource bufferedFileResource, byte[] target, String expectedStream) throws IOException {
        InputStream inputStream = bufferedFileResource.createStream();
        inputStream.read(target);
        MatcherAssert.assertThat((Object)new String(target), (Matcher)CoreMatchers.equalTo((Object)expectedStream));
        inputStream.close();
    }

    private FileResource getFileResource(final String stream) {
        return new FileResource(){

            public void close() throws IOException {
            }

            public InputStream createStream() throws IOException {
                return new ByteArrayInputStream(stream.getBytes());
            }

            public File getFile() throws IOException {
                return null;
            }
        };
    }
}

