/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.common.test.scanner;

import com.buschmais.jqassistant.core.scanner.api.DefaultScope;
import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.plugin.common.api.model.DirectoryDescriptor;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractContainerScannerPlugin;
import com.buschmais.jqassistant.plugin.common.api.scanner.FileResolver;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FileResource;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.Resource;
import com.github.benmanes.caffeine.cache.Cache;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class FileContainerScannerPluginTest {
    @Mock
    private Scanner scanner;
    @Mock
    private ScannerContext context;
    @Mock
    private Store store;
    @Mock
    private Cache cache;

    @BeforeEach
    public void stub() {
        Mockito.when((Object)this.scanner.getContext()).thenReturn((Object)this.context);
        Mockito.when((Object)this.context.getStore()).thenReturn((Object)this.store);
        Mockito.when((Object)this.store.create(FileDescriptor.class)).thenReturn(Mockito.mock(FileDescriptor.class));
        ((Store)Mockito.doReturn((Object)this.cache).when((Object)this.store)).getCache(Mockito.anyString());
        ((Cache)Mockito.doAnswer(invocation -> (FileDescriptor)((Function)invocation.getArgument(1)).apply(invocation.getArgument(0))).when((Object)this.cache)).get((Object)Mockito.anyString(), (Function)Mockito.any(Function.class));
        LinkedList fileResolvers = new LinkedList();
        ((ScannerContext)Mockito.doAnswer(invocation -> {
            FileResolver resolver = (FileResolver)invocation.getArguments()[1];
            fileResolvers.push(resolver);
            return null;
        }).when((Object)this.context)).push((Class)Mockito.eq(FileResolver.class), Mockito.any(FileResolver.class));
        Mockito.when((Object)this.context.peek(FileResolver.class)).then(invocation -> (FileResolver)fileResolvers.peek());
        Mockito.when((Object)this.scanner.scan(Mockito.any(FileResource.class), Mockito.anyString(), (Scope)Mockito.eq((Object)DefaultScope.NONE))).thenAnswer(invocation -> {
            String path = (String)invocation.getArguments()[1];
            if ("/reject".equals(path)) {
                return null;
            }
            FileResolver fileResolver = (FileResolver)this.context.peek(FileResolver.class);
            fileResolver.require("/D", FileDescriptor.class, this.context);
            return fileResolver.match(path, FileDescriptor.class, this.context);
        });
    }

    @Test
    public void contains() throws IOException {
        TestContainerScannerPlugin scannerPlugin = new TestContainerScannerPlugin();
        DirectoryDescriptor directoryDescriptor = (DirectoryDescriptor)scannerPlugin.scan(Arrays.asList("A", "B", "C", "reject"), "/", (Scope)DefaultScope.NONE, this.scanner);
        MatcherAssert.assertThat((Object)directoryDescriptor, (Matcher)CoreMatchers.notNullValue());
        ((DirectoryDescriptor)Mockito.verify((Object)directoryDescriptor)).setFileName("/");
        List<FileDescriptor> contains = scannerPlugin.getContains();
        MatcherAssert.assertThat((Object)contains.size(), (Matcher)CoreMatchers.equalTo((Object)3));
        MatcherAssert.assertThat(contains, (Matcher)CoreMatchers.equalTo((Object)directoryDescriptor.getContains()));
        FileDescriptor a = contains.get(0);
        ((FileDescriptor)Mockito.verify((Object)a)).setFileName("/A");
        FileDescriptor b = contains.get(1);
        ((FileDescriptor)Mockito.verify((Object)b)).setFileName("/B");
        FileDescriptor c = contains.get(2);
        ((FileDescriptor)Mockito.verify((Object)c)).setFileName("/C");
        List<FileDescriptor> requires = scannerPlugin.getRequires();
        MatcherAssert.assertThat((Object)requires.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat(requires, (Matcher)CoreMatchers.equalTo((Object)directoryDescriptor.getRequires()));
        FileDescriptor requiredFileDescriptor = requires.get(0);
        ((FileDescriptor)Mockito.verify((Object)requiredFileDescriptor)).setFileName("/D");
    }

    @Test
    public void requires() throws IOException {
        TestContainerScannerPlugin scannerPlugin = new TestContainerScannerPlugin();
        DirectoryDescriptor directoryDescriptor = (DirectoryDescriptor)scannerPlugin.scan(Arrays.asList("A", "D"), "/", (Scope)DefaultScope.NONE, this.scanner);
        MatcherAssert.assertThat((Object)directoryDescriptor, (Matcher)CoreMatchers.notNullValue());
        ((DirectoryDescriptor)Mockito.verify((Object)directoryDescriptor)).setFileName("/");
        List<FileDescriptor> contains = scannerPlugin.getContains();
        MatcherAssert.assertThat((Object)contains.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        MatcherAssert.assertThat(contains, (Matcher)CoreMatchers.equalTo((Object)directoryDescriptor.getContains()));
        FileDescriptor a = contains.get(0);
        ((FileDescriptor)Mockito.verify((Object)a)).setFileName("/A");
        FileDescriptor b = contains.get(1);
        ((FileDescriptor)Mockito.verify((Object)b)).setFileName("/D");
        List<FileDescriptor> requires = scannerPlugin.getRequires();
        MatcherAssert.assertThat((Object)requires.size(), (Matcher)CoreMatchers.equalTo((Object)0));
        MatcherAssert.assertThat(requires, (Matcher)CoreMatchers.equalTo((Object)directoryDescriptor.getRequires()));
    }

    private static class TestContainerScannerPlugin
    extends AbstractContainerScannerPlugin<Collection<String>, String, DirectoryDescriptor> {
        private List<FileDescriptor> contains = new ArrayList<FileDescriptor>();
        private List<FileDescriptor> requires = new ArrayList<FileDescriptor>();

        private TestContainerScannerPlugin() {
        }

        public boolean accepts(Collection<String> item, String path, Scope scope) throws IOException {
            return true;
        }

        protected DirectoryDescriptor getContainerDescriptor(Collection<String> container, ScannerContext scannerContext) {
            DirectoryDescriptor directoryDescriptor = (DirectoryDescriptor)Mockito.mock(DirectoryDescriptor.class);
            Mockito.when((Object)directoryDescriptor.getContains()).thenReturn(this.contains);
            Mockito.when((Object)directoryDescriptor.getRequires()).thenReturn(this.requires);
            return directoryDescriptor;
        }

        protected Iterable<? extends String> getEntries(Collection<String> container) throws IOException {
            return container;
        }

        protected String getContainerPath(Collection<String> container, String path) {
            return path;
        }

        protected String getRelativePath(Collection<String> container, String entry) {
            return "/" + entry;
        }

        protected void enterContainer(Collection<String> container, DirectoryDescriptor containerDescriptor, ScannerContext scannerContext) throws IOException {
        }

        protected void leaveContainer(Collection<String> container, DirectoryDescriptor containerDescriptor, ScannerContext scannerContext) throws IOException {
        }

        protected Resource getEntry(Collection<String> container, String entry) {
            return (Resource)Mockito.mock(FileResource.class);
        }

        public List<FileDescriptor> getContains() {
            return this.contains;
        }

        public List<FileDescriptor> getRequires() {
            return this.requires;
        }
    }
}

