/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.common.test.scanner;

import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FilePatternMatcher;
import java.io.IOException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Test;

public class FilePatternMatcherTest {
    private FilePatternMatcher filePatternMatcher;

    @Test
    public void includeSingleFilePattern() throws IOException {
        this.configure("*.xml", null);
        MatcherAssert.assertThat((Object)this.filePatternMatcher.accepts("test.xml"), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.filePatternMatcher.accepts("test.txt"), (Matcher)CoreMatchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.filePatternMatcher.accepts("/META-INF/persistence.xml"), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void excludeSingleFilePattern() throws IOException {
        this.configure(null, "*.xml");
        MatcherAssert.assertThat((Object)this.filePatternMatcher.accepts("test.xml"), (Matcher)CoreMatchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.filePatternMatcher.accepts("test.txt"), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.filePatternMatcher.accepts("/META-INF/persistence.xml"), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void includeAndExcludeSingleFilePatterns() throws IOException {
        this.configure("test.*", "*.xml");
        MatcherAssert.assertThat((Object)this.filePatternMatcher.accepts("test.xml"), (Matcher)CoreMatchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.filePatternMatcher.accepts("test.txt"), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.filePatternMatcher.accepts("other.txt"), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void includeMultipleFilePatterns() throws IOException {
        this.configure("*.xml, *.xsd", null);
        MatcherAssert.assertThat((Object)this.filePatternMatcher.accepts("test.xml"), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.filePatternMatcher.accepts("test.xsd"), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.filePatternMatcher.accepts("test.txt"), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void excludeMultipleFilePatterns() throws IOException {
        this.configure(null, "*.xml, *.xsd");
        MatcherAssert.assertThat((Object)this.filePatternMatcher.accepts("test.xml"), (Matcher)CoreMatchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.filePatternMatcher.accepts("test.xsd"), (Matcher)CoreMatchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.filePatternMatcher.accepts("test.txt"), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void includeAndExcludeMultipleFilePatterns() throws IOException {
        this.configure("test1.*,test2.*", "*.xml, *.xsd");
        MatcherAssert.assertThat((Object)this.filePatternMatcher.accepts("test1.xml"), (Matcher)CoreMatchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.filePatternMatcher.accepts("test2.xml"), (Matcher)CoreMatchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.filePatternMatcher.accepts("test1.xsd"), (Matcher)CoreMatchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.filePatternMatcher.accepts("test2.xsd"), (Matcher)CoreMatchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.filePatternMatcher.accepts("test1.txt"), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.filePatternMatcher.accepts("test2.txt"), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.filePatternMatcher.accepts("other.txt"), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void includeMultipleFilePatternsWithFolder() throws IOException {
        this.configure("/META-INF/*.xml,/WEB-INF/*.xml", null);
        MatcherAssert.assertThat((Object)this.filePatternMatcher.accepts("/META-INF/persistence.xml"), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.filePatternMatcher.accepts("/WEB-INF/persistence.xml"), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.filePatternMatcher.accepts("test.xml"), (Matcher)CoreMatchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.filePatternMatcher.accepts("test.txt"), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void excludeMultipleFilePatternsWithFolder() throws IOException {
        this.configure(null, "/META-INF/*.xml,/WEB-INF/*.xml");
        MatcherAssert.assertThat((Object)this.filePatternMatcher.accepts("/META-INF/persistence.xml"), (Matcher)CoreMatchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.filePatternMatcher.accepts("/WEB-INF/persistence.xml"), (Matcher)CoreMatchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.filePatternMatcher.accepts("test.xml"), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.filePatternMatcher.accepts("test.txt"), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    private void configure(String includes, String excludes) {
        this.filePatternMatcher = FilePatternMatcher.builder().include(includes).exclude(excludes).build();
    }
}

