/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.common.test.scanner;

import com.buschmais.jqassistant.core.scanner.api.DefaultScope;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.plugin.common.api.model.DirectoryDescriptor;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.common.test.AbstractPluginIT;
import com.buschmais.jqassistant.plugin.common.test.matcher.FileDescriptorMatcher;
import com.buschmais.jqassistant.plugin.common.test.scanner.model.DependentDirectoryDescriptor;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class FileScannerIT
extends AbstractPluginIT {
    @Test
    public void customDirectory() throws IOException {
        this.store.beginTransaction();
        File classesDirectory = this.getClassesDirectory(FileScannerIT.class);
        FileDescriptor descriptor = (FileDescriptor)this.getScanner().scan((Object)classesDirectory, classesDirectory.getAbsolutePath(), (Scope)DefaultScope.NONE);
        MatcherAssert.assertThat((Object)descriptor, (Matcher)Matchers.instanceOf(DirectoryDescriptor.class));
        DependentDirectoryDescriptor customDirectoryDescriptor = (DependentDirectoryDescriptor)descriptor;
        String expectedFileName = classesDirectory.getAbsolutePath().replace("\\", "/");
        MatcherAssert.assertThat((Object)customDirectoryDescriptor.getFileName(), (Matcher)Matchers.equalTo((Object)expectedFileName));
        String expectedFilename = "/" + FileScannerIT.class.getName().replace('.', '/') + ".class";
        MatcherAssert.assertThat((Object)customDirectoryDescriptor.getContains(), (Matcher)Matchers.hasItem(FileDescriptorMatcher.fileDescriptorMatcher(expectedFilename)));
        MatcherAssert.assertThat((Object)customDirectoryDescriptor.getContains(), (Matcher)Matchers.not((Matcher)Matchers.hasItem(FileDescriptorMatcher.fileDescriptorMatcher("/"))));
        MatcherAssert.assertThat((Object)customDirectoryDescriptor.getValue(), (Matcher)Matchers.equalTo((Object)"TEST"));
        this.store.commitTransaction();
    }

    @Test
    public void directoryContainsChildren() throws IOException {
        this.store.beginTransaction();
        File classesDirectory = this.getClassesDirectory(FileScannerIT.class);
        this.getScanner().scan((Object)classesDirectory, classesDirectory.getAbsolutePath(), (Scope)DefaultScope.NONE);
        String expectedFilename = "/" + FileScannerIT.class.getName().replace('.', '/') + ".class";
        Scanner scanner = new Scanner(expectedFilename).useDelimiter("/");
        StringBuffer currentName = new StringBuffer();
        FileDescriptor previous = null;
        while (scanner.hasNext()) {
            currentName.append('/').append(scanner.next());
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("name", currentName.toString());
            List files = this.query("match (f:File) where f.fileName=$name return f", params).getColumn("f");
            MatcherAssert.assertThat((Object)files.size(), (Matcher)Matchers.equalTo((Object)1));
            FileDescriptor current = (FileDescriptor)files.get(0);
            if (previous != null) {
                MatcherAssert.assertThat((Object)previous, (Matcher)Matchers.instanceOf(DirectoryDescriptor.class));
                MatcherAssert.assertThat((Object)((DirectoryDescriptor)previous).getContains(), (Matcher)Matchers.hasItem((Object)current));
            }
            previous = current;
        }
        this.store.commitTransaction();
    }
}

