/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.common.test.scanner;

import com.buschmais.jqassistant.core.scanner.api.DefaultScope;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.plugin.common.api.model.ArchiveDescriptor;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.model.GZipFileDescriptor;
import com.buschmais.jqassistant.plugin.common.test.AbstractPluginIT;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Test;

public class GZipFileScannerIT
extends AbstractPluginIT {
    @Test
    public void gzippedTextFile() throws IOException {
        this.store.beginTransaction();
        File gzFile = File.createTempFile("test", ".txt.gz");
        gzFile.deleteOnExit();
        FileOutputStream outputStream = new FileOutputStream(gzFile);
        outputStream.write("Hello World".getBytes());
        outputStream.close();
        FileDescriptor descriptor = (FileDescriptor)this.getScanner().scan((Object)gzFile, gzFile.getAbsolutePath(), (Scope)DefaultScope.NONE);
        MatcherAssert.assertThat((String)"Expecting a GZIP descriptor.", (Object)descriptor, (Matcher)CoreMatchers.instanceOf(GZipFileDescriptor.class));
        String expectedGZFileName = gzFile.getAbsolutePath().replace('\\', '/');
        MatcherAssert.assertThat((String)"Expecting an valid valid file name.", (Object)descriptor.getFileName(), (Matcher)CoreMatchers.equalTo((Object)expectedGZFileName));
        GZipFileDescriptor gZipFileDescriptor = (GZipFileDescriptor)descriptor;
        MatcherAssert.assertThat((String)"Expecting one entry.", (Object)gZipFileDescriptor.getContains().size(), (Matcher)CoreMatchers.equalTo((Object)1));
        FileDescriptor fileDescriptor = (FileDescriptor)gZipFileDescriptor.getContains().get(0);
        MatcherAssert.assertThat((String)"Expecting a valid entry file name, e.g. wihout .gz", (Object)fileDescriptor.getFileName(), (Matcher)CoreMatchers.equalTo((Object)expectedGZFileName.substring(0, expectedGZFileName.length() - 3)));
        this.store.commitTransaction();
    }

    @Test
    public void gzippedZipFile() throws IOException {
        this.store.beginTransaction();
        File zipFile = File.createTempFile("test", ".zip");
        zipFile.deleteOnExit();
        File gzFile = File.createTempFile("test", ".zip.gz");
        gzFile.deleteOnExit();
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(zipFile));
        zipOutputStream.close();
        GZIPOutputStream os = new GZIPOutputStream(new FileOutputStream(gzFile));
        FileInputStream in = new FileInputStream(zipFile);
        IOUtils.copy((InputStream)in, (OutputStream)os);
        in.close();
        os.close();
        FileDescriptor descriptor = (FileDescriptor)this.getScanner().scan((Object)gzFile, gzFile.getAbsolutePath(), (Scope)DefaultScope.NONE);
        MatcherAssert.assertThat((Object)descriptor, (Matcher)CoreMatchers.instanceOf(GZipFileDescriptor.class));
        MatcherAssert.assertThat((Object)descriptor.getFileName(), (Matcher)CoreMatchers.equalTo((Object)gzFile.getAbsolutePath().replace('\\', '/')));
        GZipFileDescriptor gZipFileDescriptor = (GZipFileDescriptor)descriptor;
        MatcherAssert.assertThat((Object)gZipFileDescriptor.getContains().size(), (Matcher)CoreMatchers.equalTo((Object)1));
        FileDescriptor fileDescriptor = (FileDescriptor)gZipFileDescriptor.getContains().get(0);
        MatcherAssert.assertThat((Object)fileDescriptor, (Matcher)CoreMatchers.instanceOf(ArchiveDescriptor.class));
        this.store.commitTransaction();
    }
}

