/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.common.test.scanner;

import com.buschmais.jqassistant.core.scanner.api.DefaultScope;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.model.TarArchiveDescriptor;
import com.buschmais.jqassistant.plugin.common.test.AbstractPluginIT;
import com.buschmais.jqassistant.plugin.common.test.matcher.FileDescriptorMatcher;
import com.buschmais.jqassistant.plugin.common.test.scanner.FileResourceStrategy;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.jupiter.api.Test;

public class TarScannerIT
extends AbstractPluginIT {
    @Test
    public void tarFile() throws Exception {
        this.test(FileResourceStrategy.File);
    }

    @Test
    public void tarUrl() throws Exception {
        this.test(FileResourceStrategy.Url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void test(FileResourceStrategy strategy) throws Exception {
        File archive = this.createTarArchive();
        try {
            this.store.beginTransaction();
            FileDescriptor descriptor = (FileDescriptor)this.getScanner().scan(strategy.get(archive), archive.getAbsolutePath(), (Scope)DefaultScope.NONE);
            MatcherAssert.assertThat((Object)descriptor, (Matcher)CoreMatchers.instanceOf(TarArchiveDescriptor.class));
            TarArchiveDescriptor archiveDescriptor = (TarArchiveDescriptor)descriptor;
            MatcherAssert.assertThat((Object)archiveDescriptor.getContains().size(), (Matcher)CoreMatchers.equalTo((Object)2));
            MatcherAssert.assertThat((Object)archiveDescriptor.getContains(), (Matcher)IsCollectionContaining.hasItem(FileDescriptorMatcher.fileDescriptorMatcher("/test1.txt")));
            MatcherAssert.assertThat((Object)archiveDescriptor.getContains(), (Matcher)IsCollectionContaining.hasItem(FileDescriptorMatcher.fileDescriptorMatcher("/test2.txt")));
            this.store.commitTransaction();
        }
        finally {
            archive.delete();
        }
    }

    private File createTarArchive() throws IOException {
        File archive = File.createTempFile("test", ".tar");
        TarArchiveOutputStream tarOutputStream = new TarArchiveOutputStream((OutputStream)new FileOutputStream(archive));
        this.addEntry(tarOutputStream, "test1.txt", "Foo");
        this.addEntry(tarOutputStream, "test2.txt", "Bar");
        tarOutputStream.finish();
        return archive;
    }

    private void addEntry(TarArchiveOutputStream tarOutputStream, String fileName, String content) throws IOException {
        TarArchiveEntry fileEntry = new TarArchiveEntry(fileName);
        fileEntry.setSize((long)content.getBytes().length);
        tarOutputStream.putArchiveEntry((ArchiveEntry)fileEntry);
        tarOutputStream.write(content.getBytes());
        tarOutputStream.closeArchiveEntry();
    }
}

