/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.common.test.scanner;

import com.buschmais.jqassistant.core.scanner.api.DefaultScope;
import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FileResource;
import com.buschmais.jqassistant.plugin.common.impl.scanner.UrlScannerPlugin;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import org.apache.commons.io.IOUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class URLScannerPluginTest {
    private UrlScannerPlugin plugin = new UrlScannerPlugin();
    @Mock
    private Scanner scanner;

    @BeforeAll
    public static void registerURLHandler() {
        URL.setURLStreamHandlerFactory(new TestURLStreamHandlerFactory());
    }

    @Test
    public void urls() throws IOException {
        this.scan("test:/path", "test:/path");
        this.scan("test://myhost", "test://myhost");
        this.scan("test://myhost:8080", "test://myhost:8080");
        this.scan("test://myhost:8080/path", "test://myhost:8080/path");
        this.scan("test://myhost:8080/path?value1=test1&value2=test2", "test://myhost:8080/path?value1=test1&value2=test2");
        this.scan("test://myhost:8080/path?value1=test1&value2=test2#anchor", "test://myhost:8080/path?value1=test1&value2=test2#anchor");
    }

    @Test
    public void authentication() throws IOException {
        FileResource fileResource = this.scan("test://user:secret@myhost:8080/path?value1=test1&value2=test2#anchor", "test://myhost:8080/path?value1=test1&value2=test2#anchor");
        String content = IOUtils.toString((InputStream)fileResource.createStream());
        MatcherAssert.assertThat((Object)content, (Matcher)CoreMatchers.startsWith((String)"Basic "));
    }

    private FileResource scan(String path, String expectedPath) throws IOException {
        URL url = new URL(path);
        this.plugin.scan(url, path, (Scope)DefaultScope.NONE, this.scanner);
        ArgumentCaptor resource = ArgumentCaptor.forClass(FileResource.class);
        ((Scanner)Mockito.verify((Object)this.scanner)).scan(resource.capture(), (String)Mockito.eq((Object)expectedPath), (Scope)Mockito.eq((Object)DefaultScope.NONE));
        return (FileResource)resource.getValue();
    }

    public static class TestURLStreamHandlerFactory
    implements URLStreamHandlerFactory {
        @Override
        public URLStreamHandler createURLStreamHandler(String protocol) {
            if ("test".equals(protocol)) {
                return new TestURLStreamHandler();
            }
            return null;
        }
    }

    public static class TestURLStreamHandler
    extends URLStreamHandler {
        @Override
        protected URLConnection openConnection(URL url) throws IOException {
            return new TestURLConnection(url);
        }
    }

    public static class TestURLConnection
    extends URLConnection {
        protected TestURLConnection(URL url) {
            super(url);
        }

        @Override
        public void connect() throws IOException {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            String authorization = this.getRequestProperty("Authorization");
            return new ByteArrayInputStream(authorization.getBytes());
        }
    }
}

