/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.common.test.scanner;

import com.buschmais.jqassistant.core.scanner.api.DefaultScope;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.model.ZipArchiveDescriptor;
import com.buschmais.jqassistant.plugin.common.test.AbstractPluginIT;
import com.buschmais.jqassistant.plugin.common.test.matcher.FileDescriptorMatcher;
import com.buschmais.jqassistant.plugin.common.test.scanner.FileResourceStrategy;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.jupiter.api.Test;

public class ZipScannerIT
extends AbstractPluginIT {
    @Test
    public void zipFile() throws Exception {
        this.test(FileResourceStrategy.File);
    }

    @Test
    public void zipUrl() throws Exception {
        this.test(FileResourceStrategy.Url);
    }

    @Test
    public void invalidZip() throws Exception {
        File archive = File.createTempFile("test", ".zip");
        archive.deleteOnExit();
        this.store.beginTransaction();
        FileDescriptor descriptor = (FileDescriptor)this.getScanner().scan((Object)archive, archive.getAbsolutePath(), null);
        MatcherAssert.assertThat((Object)descriptor, (Matcher)CoreMatchers.instanceOf(ZipArchiveDescriptor.class));
        ZipArchiveDescriptor zipArchiveDescriptor = (ZipArchiveDescriptor)descriptor;
        MatcherAssert.assertThat((Object)zipArchiveDescriptor.isValid(), (Matcher)CoreMatchers.equalTo((Object)false));
        this.store.commitTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void test(FileResourceStrategy strategy) throws Exception {
        File archive = this.createZipArchive();
        try {
            this.store.beginTransaction();
            FileDescriptor descriptor = (FileDescriptor)this.getScanner().scan(strategy.get(archive), archive.getAbsolutePath(), (Scope)DefaultScope.NONE);
            MatcherAssert.assertThat((Object)descriptor, (Matcher)CoreMatchers.instanceOf(ZipArchiveDescriptor.class));
            ZipArchiveDescriptor archiveDescriptor = (ZipArchiveDescriptor)descriptor;
            MatcherAssert.assertThat((Object)archiveDescriptor.isValid(), (Matcher)CoreMatchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)archiveDescriptor.getContains(), (Matcher)IsCollectionContaining.hasItem(FileDescriptorMatcher.fileDescriptorMatcher("/test1.txt")));
            MatcherAssert.assertThat((Object)archiveDescriptor.getContains(), (Matcher)IsCollectionContaining.hasItem(FileDescriptorMatcher.fileDescriptorMatcher("/test2.txt")));
            this.store.commitTransaction();
        }
        finally {
            archive.delete();
        }
    }

    private File createZipArchive() throws IOException {
        File archive = File.createTempFile("test", ".zip");
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(archive));
        this.addEntry(zipOutputStream, "test1.txt", "Foo");
        this.addEntry(zipOutputStream, "test2.txt", "Bar");
        zipOutputStream.close();
        return archive;
    }

    private void addEntry(ZipOutputStream zipOutputStream, String fileName, String content) throws IOException {
        ZipEntry fileEntry = new ZipEntry(fileName);
        fileEntry.setTime(System.currentTimeMillis());
        zipOutputStream.putNextEntry(fileEntry);
        zipOutputStream.write(content.getBytes());
        zipOutputStream.closeEntry();
    }
}

