/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.common.impl.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractScannerPlugin;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUriScannerPlugin
extends AbstractScannerPlugin<URI, Descriptor> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultUriScannerPlugin.class);
    private Set<String> schemes;

    public void initialize() {
        this.schemes = new HashSet<String>();
        this.schemes.add("file");
        this.schemes.add("http");
        this.schemes.add("https");
        this.schemes.add("ftp");
    }

    public boolean accepts(URI item, String path, Scope scope) throws IOException {
        String scheme = item.getScheme().toLowerCase();
        return this.schemes.contains(scheme);
    }

    public Descriptor scan(URI item, String path, Scope scope, Scanner scanner) throws IOException {
        URL url = item.toURL();
        LOGGER.debug("Scanning url '{}'.", (Object)url.toString());
        return scanner.scan((Object)url, path, scope);
    }
}

