/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.common.impl.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.scanner.api.ScannerPlugin;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.model.GZipFileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractScannerPlugin;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.AbstractFileResource;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FileResource;
import com.buschmais.jqassistant.plugin.common.impl.scanner.BufferedFileResource;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;

@ScannerPlugin.Requires(value={FileDescriptor.class})
public class GZIPFileScannerPlugin
extends AbstractScannerPlugin<FileResource, GZipFileDescriptor> {
    public boolean accepts(FileResource item, String path, Scope scope) throws IOException {
        return path.toLowerCase().endsWith(".gz");
    }

    public GZipFileDescriptor scan(final FileResource item, String path, Scope scope, Scanner scanner) throws IOException {
        ScannerContext context = scanner.getContext();
        Store store = context.getStore();
        FileDescriptor fileDescriptor = (FileDescriptor)context.getCurrentDescriptor();
        GZipFileDescriptor gZipFileDescriptor = (GZipFileDescriptor)store.addDescriptorType((Descriptor)fileDescriptor, GZipFileDescriptor.class);
        String uncompressedPath = path.substring(0, path.toLowerCase().indexOf(".gz"));
        try (BufferedFileResource fileResource = new BufferedFileResource(new AbstractFileResource(){

            @Override
            public InputStream createStream() throws IOException {
                return new GZIPInputStream(item.createStream());
            }
        });){
            FileDescriptor entryDescriptor = (FileDescriptor)scanner.scan((Object)fileResource, uncompressedPath, scope);
            gZipFileDescriptor.getContains().add(entryDescriptor);
        }
        return gZipFileDescriptor;
    }
}

