/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.common.impl.report;

import com.buschmais.jqassistant.core.report.api.ReportContext;
import com.buschmais.jqassistant.core.report.api.ReportException;
import com.buschmais.jqassistant.core.report.api.ReportHelper;
import com.buschmais.jqassistant.core.report.api.ReportPlugin;
import com.buschmais.jqassistant.core.report.api.model.Column;
import com.buschmais.jqassistant.core.report.api.model.Result;
import com.buschmais.jqassistant.core.report.api.model.Row;
import com.buschmais.jqassistant.core.rule.api.model.ExecutableRule;
import com.buschmais.jqassistant.core.rule.api.model.Rule;
import com.opencsv.CSVWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CSVReportPlugin
implements ReportPlugin {
    public static final String REPORT_TYPE = "csv";
    public static final String PROPERTY_SEPARATOR = "csv.report.separator";
    public static final String PROPERTY_QUOTE_CHAR = "csv.report.quoteChar";
    public static final String PROPERTY_ESCAPE_CHAR = "csv.report.escapeChar";
    public static final String PROPERTY_LINE_END = "csv.report.lineEnd";
    private ReportContext reportContext;
    private char separator;
    private char quotechar;
    private char escapechar;
    private String lineEnd;

    public void configure(ReportContext reportContext, Map<String, Object> properties) throws ReportException {
        this.reportContext = reportContext;
        this.separator = this.getChar(properties, PROPERTY_SEPARATOR, ',');
        this.quotechar = this.getChar(properties, PROPERTY_QUOTE_CHAR, '\"');
        this.escapechar = this.getChar(properties, PROPERTY_ESCAPE_CHAR, '\"');
        Object lineEndProperty = properties.get(PROPERTY_LINE_END);
        this.lineEnd = lineEndProperty != null ? lineEndProperty.toString() : "\n";
    }

    private char getChar(Map<String, Object> properties, String key, char defaultValue) throws ReportException {
        String value = (String)properties.get(key);
        if (value == null) {
            return defaultValue;
        }
        if (value.length() == 1) {
            return value.charAt(0);
        }
        throw new ReportException("Expecting a single character for property " + key + ", got " + value);
    }

    public void setResult(Result<? extends ExecutableRule> result) throws ReportException {
        String fileName = ReportHelper.escapeRuleId((Rule)result.getRule()) + ".csv";
        File reportDirectory = this.reportContext.getReportDirectory(REPORT_TYPE);
        File csvFile = new File(reportDirectory, fileName);
        try (CSVWriter csvWriter = new CSVWriter((Writer)new BufferedWriter(new FileWriter(csvFile)), this.separator, this.quotechar, this.escapechar, this.lineEnd);){
            List columnNames = result.getColumnNames();
            if (columnNames != null) {
                csvWriter.writeNext(columnNames.toArray(new String[columnNames.size()]));
                for (Row row : result.getRows()) {
                    ArrayList<String> csvRow = new ArrayList<String>(columnNames.size());
                    for (String columnName : columnNames) {
                        csvRow.add(((Column)row.getColumns().get(columnName)).getLabel());
                    }
                    csvWriter.writeNext(csvRow.toArray(new String[columnNames.size()]));
                }
            }
        }
        catch (IOException e) {
            throw new ReportException("Cannot write CSV report " + csvFile, (Throwable)e);
        }
        try {
            this.reportContext.addReport("CSV", result.getRule(), ReportContext.ReportType.LINK, csvFile.toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new ReportException("Cannot convert file " + csvFile.getPath() + " to URL.", (Throwable)e);
        }
    }
}

