/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.graphml.report.impl;

import com.buschmais.jqassistant.core.report.api.graph.model.Node;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class MetaInformation {
    public static final Set<String> GRAPHML_ALLOWED = new HashSet<String>(Arrays.asList("boolean", "int", "long", "float", "double", "string"));

    public static String typeFor(Class value, Set<String> allowed) {
        if (value == Void.TYPE) {
            return null;
        }
        if (value.isArray()) {
            return null;
        }
        String name = value.getSimpleName().toLowerCase();
        if (name.equals("integer")) {
            name = "int";
        }
        if (allowed == null || allowed.contains(name)) {
            return name;
        }
        if (Number.class.isAssignableFrom(value)) {
            return "int";
        }
        return null;
    }

    public static String getLabelsString(Node node) {
        if (node.getLabels().isEmpty()) {
            return "";
        }
        StringBuilder labels = new StringBuilder();
        for (String label : node.getLabels()) {
            labels.append(':').append(label);
        }
        return labels.toString();
    }
}

