/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.graphql.impl.scanner;

import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.scanner.api.ScannerPlugin;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FileResource;
import com.buschmais.jqassistant.plugin.graphql.api.model.SchemaDescriptor;
import com.buschmais.jqassistant.plugin.graphql.api.model.SchemaFileDescriptor;
import com.buschmais.jqassistant.plugin.graphql.impl.scanner.AbstractGraphQLSchemaScannerPlugin;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.io.IOException;

@ScannerPlugin.Requires(value={FileDescriptor.class})
public class GraphQLSchemaFileScannerPlugin
extends AbstractGraphQLSchemaScannerPlugin<FileResource> {
    private final SchemaParser schemaParser = new SchemaParser();

    protected <T> Class<T> getTypeParameter(Class<?> expectedSuperClass, int genericTypeParameterIndex) {
        return FileResource.class;
    }

    public boolean accepts(FileResource fileResource, String path, Scope scope) {
        return path.toLowerCase().endsWith(".graphql") || path.toLowerCase().endsWith(".graphqls");
    }

    @Override
    protected SchemaDescriptor getSchemaDescriptor(String path, ScannerContext context) {
        FileDescriptor fileDescriptor = (FileDescriptor)context.peek(FileDescriptor.class);
        return (SchemaDescriptor)context.getStore().addDescriptorType((Descriptor)fileDescriptor, SchemaFileDescriptor.class);
    }

    @Override
    protected TypeDefinitionRegistry createTypeDefinitionRegistry(FileResource resource) throws IOException {
        return this.schemaParser.parse(resource.createStream());
    }
}

