/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.graphql.impl.scanner;

import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.plugin.graphql.api.model.SchemaDescriptor;
import com.buschmais.jqassistant.plugin.graphql.api.model.SchemaUrlDescriptor;
import com.buschmais.jqassistant.plugin.graphql.impl.scanner.AbstractGraphQLSchemaScannerPlugin;
import com.buschmais.jqassistant.plugin.graphql.scope.GraphQLScope;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import graphql.introspection.IntrospectionResultToSchema;
import graphql.language.Document;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLSchemaURLScannerPlugin
extends AbstractGraphQLSchemaScannerPlugin<URL> {
    private static final Logger log = LoggerFactory.getLogger(GraphQLSchemaURLScannerPlugin.class);

    protected <T> Class<T> getTypeParameter(Class<?> expectedSuperClass, int genericTypeParameterIndex) {
        return URL.class;
    }

    public boolean accepts(URL url, String path, Scope scope) {
        return GraphQLScope.SCHEMA.equals(scope);
    }

    @Override
    protected SchemaDescriptor getSchemaDescriptor(String path, ScannerContext context) {
        SchemaUrlDescriptor schemaUrlDescriptor = (SchemaUrlDescriptor)context.getStore().create(SchemaUrlDescriptor.class);
        schemaUrlDescriptor.setURL(path);
        return schemaUrlDescriptor;
    }

    @Override
    protected TypeDefinitionRegistry createTypeDefinitionRegistry(URL resource) throws IOException {
        DefaultClientConfig clientConfig = new DefaultClientConfig();
        clientConfig.getFeatures().put("com.sun.jersey.api.json.POJOMappingFeature", Boolean.TRUE);
        Client client = Client.create((ClientConfig)clientConfig);
        WebResource.Builder requestBuilder = null;
        try {
            requestBuilder = client.resource(resource.toURI()).getRequestBuilder();
        }
        catch (URISyntaxException e) {
            throw new IOException("Cannot convert URL " + resource + " to URI.", e);
        }
        log.info("Executing introspection query.");
        GraphQLResponse response = (GraphQLResponse)((WebResource.Builder)((WebResource.Builder)requestBuilder.type(MediaType.APPLICATION_JSON_TYPE)).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE})).post(GraphQLResponse.class, (Object)GraphQLRequest.builder().query("\n  query IntrospectionQuery {\n    __schema {\n      queryType { name }\n      mutationType { name }\n      subscriptionType { name }\n      types {\n        ...FullType\n      }\n      directives {\n        name\n        description\n        locations\n        args {\n          ...InputValue\n        }\n      }\n    }\n  }\n\n  fragment FullType on __Type {\n    kind\n    name\n    description\n    fields(includeDeprecated: true) {\n      name\n      description\n      args {\n        ...InputValue\n      }\n      type {\n        ...TypeRef\n      }\n      isDeprecated\n      deprecationReason\n    }\n    inputFields {\n      ...InputValue\n    }\n    interfaces {\n      ...TypeRef\n    }\n    enumValues(includeDeprecated: true) {\n      name\n      description\n      isDeprecated\n      deprecationReason\n    }\n    possibleTypes {\n      ...TypeRef\n    }\n  }\n\n  fragment InputValue on __InputValue {\n    name\n    description\n    type { ...TypeRef }\n    defaultValue\n  }\n\nfragment TypeRef on __Type {\n    kind\n    name\n    ofType {\n      kind\n      name\n      ofType {\n        kind\n        name\n        ofType {\n          kind\n          name\n          ofType {\n            kind\n            name\n            ofType {\n              kind\n              name\n              ofType {\n                kind\n                name\n                ofType {\n                  kind\n                  name\n                }\n              }\n            }\n          }\n        }\n      }\n    }\n  }\n\n").build());
        log.info("Introspection query finished successfully.");
        Map<String, Object> data = response.getData();
        IntrospectionResultToSchema schema = new IntrospectionResultToSchema();
        Document schemaDefinition = schema.createSchemaDefinition(data);
        return new SchemaParser().buildRegistry(schemaDefinition);
    }

    private static class GraphQLResponse {
        private Map<String, Object> data;

        private GraphQLResponse() {
        }

        public void setData(Map<String, Object> data) {
            this.data = data;
        }

        public Map<String, Object> getData() {
            return this.data;
        }

        public String toString() {
            return "GraphQLSchemaURLScannerPlugin.GraphQLResponse(data=" + this.getData() + ")";
        }
    }

    private static class GraphQLRequest {
        private String query;

        GraphQLRequest(String query) {
            this.query = query;
        }

        public static GraphQLRequestBuilder builder() {
            return new GraphQLRequestBuilder();
        }

        public String getQuery() {
            return this.query;
        }

        public String toString() {
            return "GraphQLSchemaURLScannerPlugin.GraphQLRequest(query=" + this.getQuery() + ")";
        }

        public static class GraphQLRequestBuilder {
            private String query;

            GraphQLRequestBuilder() {
            }

            public GraphQLRequestBuilder query(String query) {
                this.query = query;
                return this;
            }

            public GraphQLRequest build() {
                return new GraphQLRequest(this.query);
            }

            public String toString() {
                return "GraphQLSchemaURLScannerPlugin.GraphQLRequest.GraphQLRequestBuilder(query=" + this.query + ")";
            }
        }
    }
}

