/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.graphql.impl.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractScannerPlugin;
import com.buschmais.jqassistant.plugin.graphql.api.model.SchemaDescriptor;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.errors.SchemaProblem;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGraphQLSchemaScannerPlugin<R>
extends AbstractScannerPlugin<R, SchemaDescriptor> {
    private static final Logger log = LoggerFactory.getLogger(AbstractGraphQLSchemaScannerPlugin.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SchemaDescriptor scan(R resource, String path, Scope scope, Scanner scanner) throws IOException {
        TypeDefinitionRegistry registry;
        ScannerContext context = scanner.getContext();
        SchemaDescriptor schemaDescriptor = this.getSchemaDescriptor(path, context);
        try {
            registry = this.createTypeDefinitionRegistry(resource);
        }
        catch (SchemaProblem schemaProblem) {
            log.info("Cannot read GraphQL schema from {}: {}", (Object)path, (Object)schemaProblem.getMessage());
            schemaDescriptor.setValid(false);
            return schemaDescriptor;
        }
        schemaDescriptor.setValid(true);
        context.push(SchemaDescriptor.class, (Object)schemaDescriptor);
        try {
            SchemaDescriptor schemaDescriptor2 = (SchemaDescriptor)scanner.scan((Object)registry, path, scope);
            return schemaDescriptor2;
        }
        finally {
            context.pop(SchemaDescriptor.class);
        }
    }

    protected abstract SchemaDescriptor getSchemaDescriptor(String var1, ScannerContext var2);

    protected abstract TypeDefinitionRegistry createTypeDefinitionRegistry(R var1) throws IOException;
}

