/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.graphql.impl.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractScannerPlugin;
import com.buschmais.jqassistant.plugin.graphql.api.model.ArgumentDescriptor;
import com.buschmais.jqassistant.plugin.graphql.api.model.DescriptionTemplate;
import com.buschmais.jqassistant.plugin.graphql.api.model.DirectiveContainerTemplate;
import com.buschmais.jqassistant.plugin.graphql.api.model.DirectiveLocationDescriptor;
import com.buschmais.jqassistant.plugin.graphql.api.model.DirectiveTypeDescriptor;
import com.buschmais.jqassistant.plugin.graphql.api.model.DirectiveValueDescriptor;
import com.buschmais.jqassistant.plugin.graphql.api.model.EnumTypeDescriptor;
import com.buschmais.jqassistant.plugin.graphql.api.model.EnumValueDescriptor;
import com.buschmais.jqassistant.plugin.graphql.api.model.FieldContainerTemplate;
import com.buschmais.jqassistant.plugin.graphql.api.model.FieldDescriptor;
import com.buschmais.jqassistant.plugin.graphql.api.model.FieldOfTypeDescriptor;
import com.buschmais.jqassistant.plugin.graphql.api.model.InputDescriptor;
import com.buschmais.jqassistant.plugin.graphql.api.model.InputFieldDescriptor;
import com.buschmais.jqassistant.plugin.graphql.api.model.InputObjectTypeDescriptor;
import com.buschmais.jqassistant.plugin.graphql.api.model.InputValueContainerTemplate;
import com.buschmais.jqassistant.plugin.graphql.api.model.InputValueDefinitionDescriptor;
import com.buschmais.jqassistant.plugin.graphql.api.model.InputValueOfTypeDescriptor;
import com.buschmais.jqassistant.plugin.graphql.api.model.InterfaceTypeDescriptor;
import com.buschmais.jqassistant.plugin.graphql.api.model.ListTypeDescriptor;
import com.buschmais.jqassistant.plugin.graphql.api.model.NameTemplate;
import com.buschmais.jqassistant.plugin.graphql.api.model.ObjectTypeDescriptor;
import com.buschmais.jqassistant.plugin.graphql.api.model.OfElementTypeDescriptor;
import com.buschmais.jqassistant.plugin.graphql.api.model.OfTypeTemplate;
import com.buschmais.jqassistant.plugin.graphql.api.model.ScalarTypeDescriptor;
import com.buschmais.jqassistant.plugin.graphql.api.model.ScalarValueDescriptor;
import com.buschmais.jqassistant.plugin.graphql.api.model.SchemaDescriptor;
import com.buschmais.jqassistant.plugin.graphql.api.model.SourceLocationTemplate;
import com.buschmais.jqassistant.plugin.graphql.api.model.TypeDescriptor;
import com.buschmais.jqassistant.plugin.graphql.api.model.UnionDeclaresTypeDescriptor;
import com.buschmais.jqassistant.plugin.graphql.api.model.UnionTypeDescriptor;
import com.buschmais.jqassistant.plugin.graphql.api.model.ValueDescriptor;
import com.buschmais.jqassistant.plugin.graphql.impl.scanner.TypeResolver;
import graphql.language.Argument;
import graphql.language.BooleanValue;
import graphql.language.Description;
import graphql.language.Directive;
import graphql.language.DirectiveDefinition;
import graphql.language.DirectiveLocation;
import graphql.language.DirectivesContainer;
import graphql.language.EnumTypeDefinition;
import graphql.language.EnumValue;
import graphql.language.EnumValueDefinition;
import graphql.language.FieldDefinition;
import graphql.language.FloatValue;
import graphql.language.InputObjectTypeDefinition;
import graphql.language.InputValueDefinition;
import graphql.language.IntValue;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.ListType;
import graphql.language.NamedNode;
import graphql.language.NonNullType;
import graphql.language.ObjectTypeDefinition;
import graphql.language.ScalarTypeDefinition;
import graphql.language.ScalarValue;
import graphql.language.StringValue;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import graphql.language.UnionTypeDefinition;
import graphql.language.Value;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLTypeDefinitionRegistryScannerPlugin
extends AbstractScannerPlugin<TypeDefinitionRegistry, SchemaDescriptor> {
    private static final Logger log = LoggerFactory.getLogger(GraphQLTypeDefinitionRegistryScannerPlugin.class);

    public boolean accepts(TypeDefinitionRegistry typeDefinitionRegistry, String s, Scope scope) {
        return true;
    }

    public SchemaDescriptor scan(TypeDefinitionRegistry typeDefinitionRegistry, String path, Scope scope, Scanner scanner) throws IOException {
        SchemaDescriptor schema = (SchemaDescriptor)scanner.getContext().peek(SchemaDescriptor.class);
        Store store = scanner.getContext().getStore();
        try (TypeResolver typeResolver = new TypeResolver(schema, store);){
            TypeDescriptor typeDescriptor;
            this.processDirectiveDefinitions(typeDefinitionRegistry.getDirectiveDefinitions().values(), typeResolver, store);
            for (ScalarTypeDefinition scalarTypeDefinition : typeDefinitionRegistry.scalars().values()) {
                typeDescriptor = this.process(scalarTypeDefinition, typeResolver);
                this.processDirectives((DirectivesContainer<?>)scalarTypeDefinition, typeDescriptor, typeResolver, store);
                this.processSourceLocation((NamedNode<?>)scalarTypeDefinition, typeDescriptor);
            }
            for (TypeDefinition typeDefinition : typeDefinitionRegistry.types().values()) {
                if (typeDefinition instanceof EnumTypeDefinition) {
                    typeDescriptor = this.process((EnumTypeDefinition)typeDefinition, typeResolver, store);
                } else if (typeDefinition instanceof ObjectTypeDefinition) {
                    typeDescriptor = this.process((ObjectTypeDefinition)typeDefinition, typeResolver, store);
                } else if (typeDefinition instanceof InputObjectTypeDefinition) {
                    typeDescriptor = this.process((InputObjectTypeDefinition)typeDefinition, typeResolver, store);
                } else if (typeDefinition instanceof InterfaceTypeDefinition) {
                    typeDescriptor = this.process((InterfaceTypeDefinition)typeDefinition, typeResolver, store);
                } else if (typeDefinition instanceof UnionTypeDefinition) {
                    typeDescriptor = this.process((UnionTypeDefinition)typeDefinition, typeResolver, store);
                } else {
                    throw new IOException("Unsupported GraphQL type " + typeDefinition);
                }
                this.processSourceLocation((NamedNode<?>)typeDefinition, typeDescriptor);
                this.processDirectives((DirectivesContainer<?>)typeDefinition, typeDescriptor, typeResolver, store);
            }
        }
        return schema;
    }

    private void processDirectiveDefinitions(Collection<DirectiveDefinition> directiveDefinitions, TypeResolver typeResolver, Store store) throws IOException {
        HashMap<String, DirectiveLocationDescriptor> directiveLocations = new HashMap<String, DirectiveLocationDescriptor>();
        for (DirectiveDefinition directiveDefinition : directiveDefinitions) {
            DirectiveTypeDescriptor directiveTypeDescriptor = typeResolver.declare((NamedNode<?>)directiveDefinition, DirectiveTypeDescriptor.class);
            this.resolveInputValues(directiveDefinition.getInputValueDefinitions(), directiveTypeDescriptor, typeResolver, store);
            for (DirectiveLocation directiveLocation : directiveDefinition.getDirectiveLocations()) {
                String name = directiveLocation.getName();
                DirectiveLocationDescriptor locationDescriptor = directiveLocations.computeIfAbsent(name, key -> (DirectiveLocationDescriptor)store.create(DirectiveLocationDescriptor.class, d -> d.setName(name)));
                directiveTypeDescriptor.getDeclaresLocations().add(locationDescriptor);
            }
            this.processSourceLocation((NamedNode<?>)directiveDefinition, directiveTypeDescriptor);
            this.processDescription(directiveDefinition.getDescription(), directiveTypeDescriptor);
        }
    }

    private void processDescription(Description description, DescriptionTemplate descriptionTemplate) {
        if (description != null) {
            descriptionTemplate.setDescription(description.getContent());
        }
    }

    private void processDirectives(DirectivesContainer<?> directivesContainer, DirectiveContainerTemplate directiveContainerTemplate, TypeResolver typeResolver, Store store) throws IOException {
        for (Directive directive : directivesContainer.getDirectives()) {
            DirectiveTypeDescriptor directiveTypeDescriptor = typeResolver.require((NamedNode<?>)directive, DirectiveTypeDescriptor.class);
            DirectiveValueDescriptor directiveValueDescriptor = (DirectiveValueDescriptor)store.create(DirectiveValueDescriptor.class);
            directiveValueDescriptor.setOfType(directiveTypeDescriptor);
            this.resolveArguments(directive.getArguments(), directiveTypeDescriptor, directiveValueDescriptor, store);
            directiveContainerTemplate.getDeclaresDirectives().add(directiveValueDescriptor);
        }
    }

    private void resolveArguments(List<Argument> arguments, DirectiveTypeDescriptor directiveTypeDescriptor, DirectiveValueDescriptor directiveValueDescriptor, Store store) throws IOException {
        int index = 0;
        for (Argument argument : arguments) {
            ArgumentDescriptor argumentDescriptor = (ArgumentDescriptor)store.create(ArgumentDescriptor.class);
            InputValueDefinitionDescriptor inputValueDefinitionDescriptor = directiveTypeDescriptor.resolveInputValue(argument.getName());
            argumentDescriptor.setInputValue(inputValueDefinitionDescriptor);
            argumentDescriptor.setIndex(index);
            ++index;
            ValueDescriptor valueDescriptor = this.resolveValue(inputValueDefinitionDescriptor, argument.getValue(), store);
            argumentDescriptor.setValue(valueDescriptor);
            directiveValueDescriptor.getHasArguments().add(argumentDescriptor);
        }
    }

    private TypeDescriptor process(ScalarTypeDefinition type, TypeResolver typeResolver) {
        ScalarTypeDescriptor scalarTypeDescriptor = typeResolver.declare((NamedNode<?>)type, ScalarTypeDescriptor.class);
        this.processDescription(type.getDescription(), scalarTypeDescriptor);
        return scalarTypeDescriptor;
    }

    private TypeDescriptor process(EnumTypeDefinition type, TypeResolver typeResolver, Store store) throws IOException {
        EnumTypeDescriptor enumTypeDescriptor = typeResolver.declare((NamedNode<?>)type, EnumTypeDescriptor.class);
        this.processDescription(type.getDescription(), enumTypeDescriptor);
        for (EnumValueDefinition value : type.getEnumValueDefinitions()) {
            EnumValueDescriptor enumValueDescriptor = enumTypeDescriptor.resolveValue(value.getName());
            this.processDescription(value.getDescription(), enumValueDescriptor);
            this.processDirectives((DirectivesContainer<?>)value, enumValueDescriptor, typeResolver, store);
        }
        return enumTypeDescriptor;
    }

    private TypeDescriptor process(ObjectTypeDefinition type, TypeResolver typeResolver, Store store) throws IOException {
        ObjectTypeDescriptor objectTypeDescriptor = typeResolver.declare((NamedNode<?>)type, ObjectTypeDescriptor.class);
        this.processDescription(type.getDescription(), objectTypeDescriptor);
        for (Type interfaceType : type.getImplements()) {
            InterfaceTypeDescriptor interfaceTypeDescriptor = typeResolver.require((NamedNode<?>)((TypeName)interfaceType), InterfaceTypeDescriptor.class);
            objectTypeDescriptor.getImplements().add(interfaceTypeDescriptor);
        }
        this.processFieldDefinitions(type.getFieldDefinitions(), objectTypeDescriptor, typeResolver, store);
        return objectTypeDescriptor;
    }

    private TypeDescriptor process(InterfaceTypeDefinition type, TypeResolver typeResolver, Store store) throws IOException {
        InterfaceTypeDescriptor interfaceTypeDescriptor = typeResolver.declare((NamedNode<?>)type, InterfaceTypeDescriptor.class);
        this.processDescription(type.getDescription(), interfaceTypeDescriptor);
        this.processFieldDefinitions(type.getFieldDefinitions(), interfaceTypeDescriptor, typeResolver, store);
        return interfaceTypeDescriptor;
    }

    private TypeDescriptor process(UnionTypeDefinition type, TypeResolver typeResolver, Store store) {
        UnionTypeDescriptor unionTypeDescriptor = typeResolver.declare((NamedNode<?>)type, UnionTypeDescriptor.class);
        this.processDescription(type.getDescription(), unionTypeDescriptor);
        int index = 0;
        for (Type memberType : type.getMemberTypes()) {
            TypeDescriptor typeDescriptor = typeResolver.require((NamedNode<?>)((TypeName)memberType), TypeDescriptor.class);
            UnionDeclaresTypeDescriptor unionDeclaresType = (UnionDeclaresTypeDescriptor)store.create((Descriptor)unionTypeDescriptor, UnionDeclaresTypeDescriptor.class, (Descriptor)typeDescriptor);
            unionDeclaresType.setIndex(index);
            ++index;
        }
        return unionTypeDescriptor;
    }

    private void processFieldDefinitions(List<FieldDefinition> fieldDefinitions, FieldContainerTemplate fieldContainerTemplate, TypeResolver typeResolver, Store store) throws IOException {
        for (FieldDefinition fieldDefinition : fieldDefinitions) {
            FieldDescriptor fieldDescriptor = (FieldDescriptor)store.create(FieldDescriptor.class);
            fieldDescriptor.setName(fieldDefinition.getName());
            this.processDescription(fieldDefinition.getDescription(), fieldDescriptor);
            this.resolveFieldType(fieldDescriptor, FieldOfTypeDescriptor.class, fieldDefinition.getType(), typeResolver, store);
            this.resolveInputValues(fieldDefinition.getInputValueDefinitions(), fieldDescriptor, typeResolver, store);
            fieldContainerTemplate.getFields().add(fieldDescriptor);
            this.processSourceLocation((NamedNode<?>)fieldDefinition, fieldDescriptor);
            this.processDirectives((DirectivesContainer<?>)fieldDefinition, fieldDescriptor, typeResolver, store);
        }
    }

    private void resolveInputValues(List<InputValueDefinition> inputValueDefinitions, InputValueContainerTemplate inputValueContainerTemplate, TypeResolver typeResolver, Store store) throws IOException {
        int index = 0;
        for (InputValueDefinition inputValueDefinition : inputValueDefinitions) {
            InputValueDefinitionDescriptor inputValueDefinitionDescriptor = this.createInputDescriptor((NamedNode<?>)inputValueDefinition, (Class)InputValueDefinitionDescriptor.class, store);
            this.processDescription(inputValueDefinition.getDescription(), inputValueDefinitionDescriptor);
            inputValueDefinitionDescriptor.setIndex(index);
            ++index;
            Type type = inputValueDefinition.getType();
            this.resolveFieldType(inputValueDefinitionDescriptor, InputValueOfTypeDescriptor.class, type, typeResolver, store);
            inputValueDefinitionDescriptor.setDefaultValue(this.resolveValue(inputValueDefinitionDescriptor, inputValueDefinition.getDefaultValue(), store));
            inputValueContainerTemplate.getInputValues().add(inputValueDefinitionDescriptor);
            this.processDirectives((DirectivesContainer<?>)inputValueDefinition, inputValueDefinitionDescriptor, typeResolver, store);
        }
    }

    private ValueDescriptor resolveValue(InputValueDefinitionDescriptor inputValueDefinitionDescriptor, Value<?> value, Store store) throws IOException {
        if (value == null) {
            return null;
        }
        if (value instanceof ScalarValue) {
            Object scalarValue = this.getScalarValue((ScalarValue)value);
            ScalarValueDescriptor scalarValueDescriptor = (ScalarValueDescriptor)store.create(ScalarValueDescriptor.class);
            scalarValueDescriptor.setValue(scalarValue);
            return scalarValueDescriptor;
        }
        if (value instanceof EnumValue) {
            return inputValueDefinitionDescriptor.resolveEnumValue(((EnumValue)value).getName());
        }
        throw new IOException("Unsupported value type " + value);
    }

    private TypeDescriptor process(InputObjectTypeDefinition type, TypeResolver typeResolver, Store store) throws IOException {
        InputObjectTypeDescriptor inputObjectTypeDescriptor = typeResolver.declare((NamedNode<?>)type, InputObjectTypeDescriptor.class);
        this.processDescription(type.getDescription(), inputObjectTypeDescriptor);
        for (InputValueDefinition inputValueDefinition : type.getInputValueDefinitions()) {
            InputFieldDescriptor inputFieldDescriptor = this.createInputDescriptor((NamedNode<?>)inputValueDefinition, (Class)InputFieldDescriptor.class, store);
            this.processDescription(inputValueDefinition.getDescription(), inputFieldDescriptor);
            this.resolveFieldType(inputFieldDescriptor, FieldOfTypeDescriptor.class, inputValueDefinition.getType(), typeResolver, store);
            inputObjectTypeDescriptor.getFields().add(inputFieldDescriptor);
        }
        return inputObjectTypeDescriptor;
    }

    private <T extends InputDescriptor & NameTemplate> T createInputDescriptor(NamedNode<?> namedNode, Class<T> type, Store store) {
        return (T)((InputDescriptor)store.create(type, t -> {
            ((NameTemplate)((Object)t)).setName(namedNode.getName());
            this.processSourceLocation(namedNode, (SourceLocationTemplate)((Object)t));
        }));
    }

    private void processSourceLocation(NamedNode<?> namedNode, SourceLocationTemplate sourceLocationTemplate) {
        if (namedNode.getSourceLocation() != null) {
            sourceLocationTemplate.setLine(namedNode.getSourceLocation().getLine());
            sourceLocationTemplate.setColumn(namedNode.getSourceLocation().getColumn());
        }
    }

    private <R extends OfTypeTemplate & Descriptor> R resolveFieldType(Descriptor from, Class<R> relationType, Type type, TypeResolver typeResolver, Store store) throws IOException {
        if (type instanceof NonNullType) {
            NonNullType nonNullType = (NonNullType)type;
            Type wrappedType = nonNullType.getType();
            R relation = this.resolveFieldType(from, relationType, wrappedType, typeResolver, store);
            relation.setNonNull(true);
            return relation;
        }
        if (type instanceof ListType) {
            ListType listType = (ListType)type;
            Type elementType = listType.getType();
            ListTypeDescriptor listTypeDescriptor = (ListTypeDescriptor)store.create(ListTypeDescriptor.class);
            this.resolveFieldType(listTypeDescriptor, OfElementTypeDescriptor.class, elementType, typeResolver, store);
            return (R)((OfTypeTemplate)store.create(from, relationType, (Descriptor)listTypeDescriptor));
        }
        if (type instanceof TypeName) {
            TypeDescriptor to = typeResolver.require((NamedNode<?>)((TypeName)type), TypeDescriptor.class);
            return (R)((OfTypeTemplate)store.create(from, relationType, (Descriptor)to));
        }
        throw new IOException("Unsupported field type " + type);
    }

    private Object getScalarValue(ScalarValue<?> value) throws IOException {
        Object scalarValue;
        if (value instanceof IntValue) {
            scalarValue = ((IntValue)value).getValue().longValue();
        } else if (value instanceof FloatValue) {
            scalarValue = ((FloatValue)value).getValue();
        } else if (value instanceof StringValue) {
            scalarValue = ((StringValue)value).getValue();
        } else if (value instanceof BooleanValue) {
            scalarValue = ((BooleanValue)value).isValue();
        } else {
            throw new IOException("Unsupported scalar value type " + value.getClass());
        }
        return scalarValue;
    }
}

