/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.graphql.impl.scanner;

import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.graphql.api.model.SchemaDescriptor;
import com.buschmais.jqassistant.plugin.graphql.api.model.TypeDescriptor;
import graphql.language.NamedNode;
import java.util.HashMap;
import java.util.Map;

public class TypeResolver
implements AutoCloseable {
    private final SchemaDescriptor schemaDescriptor;
    private final Store store;
    private Map<String, TypeDescriptor> requiresTypes = new HashMap<String, TypeDescriptor>();
    private Map<String, TypeDescriptor> declaresTypes = new HashMap<String, TypeDescriptor>();

    public <T extends TypeDescriptor> T require(NamedNode<?> namedNode, Class<T> expectedType) {
        String name = namedNode.getName();
        TypeDescriptor typeDescriptor = this.declaresTypes.get(name);
        if (typeDescriptor == null) {
            typeDescriptor = this.requiresTypes.computeIfAbsent(name, key -> this.create(expectedType, (String)key));
        }
        return this.migrate(typeDescriptor, expectedType);
    }

    public <T extends TypeDescriptor> T declare(NamedNode<?> namedNode, Class<T> expectedType) {
        String name = namedNode.getName();
        TypeDescriptor resolvedDescriptor = this.requiresTypes.remove(name);
        if (resolvedDescriptor == null) {
            resolvedDescriptor = this.create(expectedType, name);
        }
        T namedElementDescriptor = this.migrate(resolvedDescriptor, expectedType);
        this.declaresTypes.put(name, (TypeDescriptor)namedElementDescriptor);
        return namedElementDescriptor;
    }

    private <T extends TypeDescriptor> T create(Class<T> expectedType, String name) {
        return (T)((TypeDescriptor)this.store.create(expectedType, d -> d.setName(name)));
    }

    private <T extends TypeDescriptor> T migrate(TypeDescriptor typeDescriptor, Class<T> expectedType) {
        if (typeDescriptor.getClass().isAssignableFrom(expectedType)) {
            return (T)typeDescriptor;
        }
        TypeDescriptor descriptor = (TypeDescriptor)this.store.addDescriptorType((Descriptor)typeDescriptor, expectedType);
        return (T)descriptor;
    }

    @Override
    public void close() {
        this.schemaDescriptor.getDeclaresTypes().addAll(this.declaresTypes.values());
        this.schemaDescriptor.getRequiresTypes().addAll(this.requiresTypes.values());
    }

    public TypeResolver(SchemaDescriptor schemaDescriptor, Store store) {
        this.schemaDescriptor = schemaDescriptor;
        this.store = store;
    }
}

