/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.java.api.report;

import com.buschmais.jqassistant.core.report.api.SourceProvider;
import com.buschmais.jqassistant.core.report.api.model.Language;
import com.buschmais.jqassistant.core.report.api.model.LanguageElement;
import com.buschmais.jqassistant.core.report.api.model.source.FileLocation;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.report.FileSourceHelper;
import com.buschmais.jqassistant.plugin.java.api.model.ClassFileDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.FieldDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.InvokesDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.MemberDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.MethodDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.PackageDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.ReadsDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.TypeDependsOnDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.VariableDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.WritesDescriptor;
import com.buschmais.jqassistant.plugin.java.api.report.TypeSourceHelper;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Optional;

@Language
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
public @interface Java {
    public JavaLanguageElement value();

    public static enum JavaLanguageElement implements LanguageElement
    {
        Package{

            public SourceProvider<PackageDescriptor> getSourceProvider() {
                return new SourceProvider<PackageDescriptor>(){

                    public String getName(PackageDescriptor descriptor) {
                        return descriptor.getFullQualifiedName();
                    }

                    public Optional<FileLocation> getSourceLocation(PackageDescriptor descriptor) {
                        return FileSourceHelper.getSourceLocation((FileDescriptor)descriptor, Optional.empty(), Optional.empty());
                    }
                };
            }
        }
        ,
        Type{

            public SourceProvider<ClassFileDescriptor> getSourceProvider() {
                return new SourceProvider<ClassFileDescriptor>(){

                    public String getName(ClassFileDescriptor descriptor) {
                        return descriptor.getFullQualifiedName();
                    }

                    public Optional<FileLocation> getSourceLocation(ClassFileDescriptor descriptor) {
                        return TypeSourceHelper.getSourceLocation(descriptor);
                    }
                };
            }
        }
        ,
        Field{

            public SourceProvider<FieldDescriptor> getSourceProvider() {
                return new FieldSourceProvider();
            }
        }
        ,
        Variable{

            public SourceProvider<VariableDescriptor> getSourceProvider() {
                return new SourceProvider<VariableDescriptor>(){

                    public String getName(VariableDescriptor descriptor) {
                        return descriptor.getMethod().getSignature() + "#" + descriptor.getSignature();
                    }

                    public Optional<FileLocation> getSourceLocation(VariableDescriptor descriptor) {
                        return TypeSourceHelper.getSourceLocation(descriptor.getMethod().getDeclaringType());
                    }
                };
            }
        }
        ,
        ReadField{

            public SourceProvider<ReadsDescriptor> getSourceProvider() {
                return new SourceProvider<ReadsDescriptor>(){

                    public String getName(ReadsDescriptor descriptor) {
                        return descriptor.getMethod().getSignature() + ", line " + descriptor.getLineNumber();
                    }

                    public Optional<FileLocation> getSourceLocation(ReadsDescriptor descriptor) {
                        return TypeSourceHelper.getSourceLocation(descriptor.getMethod().getDeclaringType(), descriptor.getLineNumber());
                    }
                };
            }
        }
        ,
        WriteField{

            public SourceProvider<WritesDescriptor> getSourceProvider() {
                return new SourceProvider<WritesDescriptor>(){

                    public String getName(WritesDescriptor descriptor) {
                        return descriptor.getMethod().getSignature() + ", line " + descriptor.getLineNumber();
                    }

                    public Optional<FileLocation> getSourceLocation(WritesDescriptor descriptor) {
                        return TypeSourceHelper.getSourceLocation(descriptor.getMethod().getDeclaringType(), descriptor.getLineNumber());
                    }
                };
            }
        }
        ,
        Method{

            public SourceProvider<MethodDescriptor> getSourceProvider() {
                return new MethodSourceProvider();
            }
        }
        ,
        Constructor{

            public SourceProvider<? extends Descriptor> getSourceProvider() {
                return new MethodSourceProvider();
            }
        }
        ,
        MethodInvocation{

            public SourceProvider<InvokesDescriptor> getSourceProvider() {
                return new SourceProvider<InvokesDescriptor>(){

                    public String getName(InvokesDescriptor descriptor) {
                        return descriptor.getInvokingMethod().getSignature() + ", line " + descriptor.getLineNumber();
                    }

                    public Optional<FileLocation> getSourceLocation(InvokesDescriptor descriptor) {
                        return TypeSourceHelper.getSourceLocation(descriptor.getInvokingMethod().getDeclaringType(), descriptor.getLineNumber());
                    }
                };
            }
        }
        ,
        TypeDepdendency{

            public SourceProvider<TypeDependsOnDescriptor> getSourceProvider() {
                return new SourceProvider<TypeDependsOnDescriptor>(){

                    public String getName(TypeDependsOnDescriptor descriptor) {
                        return descriptor.getDependent().getName() + "->" + descriptor.getDependency().getName();
                    }

                    public Optional<FileLocation> getSourceLocation(TypeDependsOnDescriptor descriptor) {
                        return TypeSourceHelper.getSourceLocation(descriptor.getDependent());
                    }
                };
            }
        };


        public String getLanguage() {
            return "Java";
        }

        private static class MethodSourceProvider
        extends MemberSourceProvider<MethodDescriptor> {
            private MethodSourceProvider() {
            }

            public Optional<FileLocation> getSourceLocation(MethodDescriptor descriptor) {
                return TypeSourceHelper.getSourceLocation(descriptor.getDeclaringType(), Optional.ofNullable(descriptor.getFirstLineNumber()), Optional.ofNullable(descriptor.getLastLineNumber()));
            }
        }

        private static class FieldSourceProvider
        extends MemberSourceProvider<FieldDescriptor> {
            private FieldSourceProvider() {
            }

            public Optional<FileLocation> getSourceLocation(FieldDescriptor descriptor) {
                return TypeSourceHelper.getSourceLocation(descriptor.getDeclaringType());
            }
        }

        private static abstract class MemberSourceProvider<D extends MemberDescriptor>
        implements SourceProvider<D> {
            private MemberSourceProvider() {
            }

            public String getName(D descriptor) {
                return descriptor.getSignature();
            }
        }
    }
}

