/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.delegate;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;

class Delegator<D> {
    private final List<D> delegates;

    void accept(Consumer<D> consumer) {
        for (D delegate : this.delegates) {
            if (delegate == null) continue;
            consumer.accept(delegate);
        }
    }

    <T> List<T> apply(Function<D, T> function) {
        ArrayList<T> list = new ArrayList<T>(this.delegates.size());
        for (D delegate : this.delegates) {
            if (delegate != null) {
                T value = function.apply(delegate);
                list.add(value);
                continue;
            }
            list.add(null);
        }
        return list;
    }

    public Delegator(List<D> delegates) {
        this.delegates = delegates;
    }
}

