/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.java.api.scanner;

import org.objectweb.asm.Type;

public final class SignatureHelper {
    private SignatureHelper() {
    }

    public static String getObjectType(String desc) {
        return SignatureHelper.getType(Type.getObjectType((String)desc));
    }

    public static String getType(String desc) {
        return SignatureHelper.getType(Type.getType((String)desc));
    }

    public static String getType(Type t) {
        switch (t.getSort()) {
            case 9: {
                return SignatureHelper.getType(t.getElementType());
            }
        }
        return t.getClassName();
    }

    public static String getMethodSignature(String name, String rawSignature) {
        StringBuilder signature = new StringBuilder();
        String returnType = Type.getReturnType((String)rawSignature).getClassName();
        if (returnType != null) {
            signature.append(returnType);
            signature.append(' ');
        }
        signature.append(name);
        signature.append('(');
        Type[] types = Type.getArgumentTypes((String)rawSignature);
        for (int i = 0; i < types.length; ++i) {
            if (i > 0) {
                signature.append(',');
            }
            signature.append(types[i].getClassName());
        }
        signature.append(')');
        return signature.toString();
    }

    public static String getFieldSignature(String name, String rawSignature) {
        StringBuilder signature = new StringBuilder();
        String returnType = Type.getType((String)rawSignature).getClassName();
        signature.append(returnType);
        signature.append(' ');
        signature.append(name);
        return signature.toString();
    }
}

