/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.java.impl.scanner.visitor;

import com.buschmais.jqassistant.plugin.common.api.model.ArrayValueDescriptor;
import com.buschmais.jqassistant.plugin.common.api.model.ValueDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.AnnotationValueDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.ClassValueDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.EnumValueDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.FieldDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.PrimitiveValueDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.TypeDescriptor;
import com.buschmais.jqassistant.plugin.java.api.scanner.SignatureHelper;
import com.buschmais.jqassistant.plugin.java.api.scanner.TypeCache;
import com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.AnnotationValueVisitor;
import com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.VisitorHelper;
import java.util.LinkedList;
import java.util.List;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Type;

public abstract class AbstractAnnotationVisitor<D>
extends AnnotationVisitor {
    private VisitorHelper visitorHelper;
    private ArrayValueDescriptor arrayValueDescriptor;
    private TypeCache.CachedType containingType;
    private D descriptor;

    protected AbstractAnnotationVisitor(TypeCache.CachedType containingType, D descriptor, VisitorHelper visitorHelper) {
        super(589824);
        this.containingType = containingType;
        this.descriptor = descriptor;
        this.visitorHelper = visitorHelper;
    }

    public void visit(String name, Object value) {
        if (value instanceof Type) {
            String type = SignatureHelper.getType((Type)value);
            ClassValueDescriptor valueDescriptor = this.createValue(ClassValueDescriptor.class, name);
            valueDescriptor.setValue((TypeDescriptor)this.visitorHelper.resolveType(type, this.containingType).getTypeDescriptor());
            this.addValue(name, valueDescriptor);
        } else {
            PrimitiveValueDescriptor valueDescriptor = this.createValue(PrimitiveValueDescriptor.class, name);
            Object typeDescriptor = this.visitorHelper.resolveType(value.getClass().getName(), this.containingType).getTypeDescriptor();
            valueDescriptor.setType((TypeDescriptor)typeDescriptor);
            valueDescriptor.setValue(value);
            this.addValue(name, valueDescriptor);
        }
    }

    public void visitEnum(String name, String desc, String value) {
        EnumValueDescriptor valueDescriptor = this.createValue(EnumValueDescriptor.class, name);
        TypeCache.CachedType cachedTypeDescriptor = this.visitorHelper.resolveType(SignatureHelper.getType(desc), this.containingType);
        FieldDescriptor fieldDescriptor = this.visitorHelper.getFieldDescriptor(cachedTypeDescriptor, SignatureHelper.getFieldSignature(value, desc));
        valueDescriptor.setType((TypeDescriptor)this.visitorHelper.resolveType(Enum.class.getName(), this.containingType).getTypeDescriptor());
        valueDescriptor.setValue(fieldDescriptor);
        this.addValue(name, valueDescriptor);
    }

    public AnnotationValueVisitor visitAnnotation(String name, String desc) {
        AnnotationValueDescriptor valueDescriptor = this.createValue(AnnotationValueDescriptor.class, name);
        valueDescriptor.setType((TypeDescriptor)this.visitorHelper.resolveType(SignatureHelper.getType(desc), this.containingType).getTypeDescriptor());
        this.addValue(name, valueDescriptor);
        return new AnnotationValueVisitor(this.containingType, valueDescriptor, this.visitorHelper);
    }

    public AnnotationVisitor visitArray(String name) {
        this.arrayValueDescriptor = this.createValue(ArrayValueDescriptor.class, name);
        this.setValue(this.descriptor, (ValueDescriptor<?>)this.arrayValueDescriptor);
        return this;
    }

    protected abstract void setValue(D var1, ValueDescriptor<?> var2);

    private <T extends ValueDescriptor<?>> T createValue(Class<T> type, String name) {
        if (name != null) {
            this.arrayValueDescriptor = null;
        }
        Object valueName = this.arrayValueDescriptor != null ? "[" + this.getArrayValue().size() + "]" : name;
        T valueDescriptor = this.visitorHelper.getValueDescriptor(type);
        valueDescriptor.setName((String)valueName);
        return valueDescriptor;
    }

    private void addValue(String name, ValueDescriptor<?> value) {
        if (this.arrayValueDescriptor != null && name == null) {
            this.getArrayValue().add(value);
        } else {
            this.setValue(this.descriptor, value);
        }
    }

    private List<ValueDescriptor<?>> getArrayValue() {
        LinkedList values = this.arrayValueDescriptor.getValue();
        if (values == null) {
            values = new LinkedList();
            this.arrayValueDescriptor.setValue(values);
        }
        return values;
    }
}

