/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.java.impl.scanner.visitor;

import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.java.api.model.MethodDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.ThrowsDescriptor;
import com.buschmais.jqassistant.plugin.java.api.scanner.SignatureHelper;
import com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.MethodDataFlowVerifier;
import com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.VisitorHelper;
import lombok.Generated;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodDataFlowVisitor
extends MethodVisitor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MethodDataFlowVisitor.class);
    private final Type type;
    private final MethodDescriptor methodDescriptor;
    private final MethodNode methodNode;
    private final VisitorHelper visitorHelper;
    private final Analyzer<BasicValue> analyzer;

    MethodDataFlowVisitor(Type type, MethodDescriptor methodDescriptor, MethodNode methodNode, MethodDataFlowVerifier methodDataFlowVerifier, VisitorHelper visitorHelper) {
        super(589824, (MethodVisitor)methodNode);
        this.type = type;
        this.methodDescriptor = methodDescriptor;
        this.methodNode = methodNode;
        this.visitorHelper = visitorHelper;
        this.analyzer = new Analyzer((Interpreter)methodDataFlowVerifier);
    }

    public void visitEnd() {
        try {
            Frame[] frames = this.analyzer.analyze(this.type.getClassName(), this.methodNode);
            Integer lineNumber = null;
            for (int i = 0; i < this.methodNode.instructions.size(); ++i) {
                AbstractInsnNode insnNode = this.methodNode.instructions.get(i);
                if (insnNode instanceof LineNumberNode) {
                    lineNumber = ((LineNumberNode)insnNode).line;
                    continue;
                }
                Frame frame = frames[i];
                if (insnNode.getOpcode() != 191) continue;
                this.athrow((Frame<BasicValue>)frame, lineNumber);
            }
        }
        catch (AnalyzerException e) {
            log.warn("Cannot analyze data flow of {}#{}: {}.", new Object[]{this.type.getClassName(), this.methodNode.signature, e.getMessage()});
            log.debug("Analyzer exception details.", (Throwable)e);
        }
    }

    private void athrow(Frame<BasicValue> frame, Integer lineNumber) {
        if (frame == null) {
            log.warn("Expected frame for athrow is null, skipping ({}#{}).", (Object)this.type.getClassName(), (Object)this.methodNode.signature);
        } else {
            String throwableType = SignatureHelper.getType(((BasicValue)frame.getStack(0)).getType());
            Object typeDescriptor = this.visitorHelper.resolveType(throwableType).getTypeDescriptor();
            ThrowsDescriptor throwsDescriptor = (ThrowsDescriptor)this.visitorHelper.getStore().create((Descriptor)this.methodDescriptor, ThrowsDescriptor.class, typeDescriptor);
            if (lineNumber != null) {
                throwsDescriptor.setLineNumber(lineNumber);
            }
        }
    }
}

