/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.m2repo.impl.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.common.api.model.ArtifactDescriptor;
import com.buschmais.jqassistant.plugin.m2repo.api.ArtifactProvider;
import com.buschmais.jqassistant.plugin.m2repo.api.model.ArtifactInfoDescriptor;
import com.buschmais.jqassistant.plugin.m2repo.api.model.MavenReleaseDescriptor;
import com.buschmais.jqassistant.plugin.m2repo.api.model.MavenSnapshotDescriptor;
import com.buschmais.jqassistant.plugin.m2repo.impl.scanner.ArtifactInfoCoordinates;
import com.buschmais.jqassistant.plugin.m2repo.impl.scanner.ArtifactSearchResult;
import com.buschmais.jqassistant.plugin.m2repo.impl.scanner.ArtifactTask;
import com.buschmais.jqassistant.plugin.m2repo.impl.scanner.EffectiveModelBuilder;
import com.buschmais.jqassistant.plugin.m2repo.impl.scanner.GAVResolver;
import com.buschmais.jqassistant.plugin.maven3.api.artifact.AetherArtifactCoordinates;
import com.buschmais.jqassistant.plugin.maven3.api.artifact.ArtifactFilter;
import com.buschmais.jqassistant.plugin.maven3.api.artifact.ArtifactResolver;
import com.buschmais.jqassistant.plugin.maven3.api.artifact.Coordinates;
import com.buschmais.jqassistant.plugin.maven3.api.artifact.MavenArtifactHelper;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenArtifactDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenPomXmlDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenRepositoryDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.scanner.PomModelBuilder;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.maven.index.ArtifactInfo;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.resolution.ArtifactResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactSearchResultScanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArtifactSearchResultScanner.class);
    private static final String EXTENSION_POM = "pom";
    private static final int QUEUE_CAPACITY = 500;
    private final Scanner scanner;
    private final ArtifactProvider artifactProvider;
    private final ArtifactFilter artifactFilter;
    private final boolean scanArtifacts;
    private final boolean keepArtifacts;

    public ArtifactSearchResultScanner(Scanner scanner, ArtifactProvider artifactProvider, ArtifactFilter artifactFilter, boolean scanArtifacts, boolean keepArtifacts) {
        this.scanner = scanner;
        this.artifactProvider = artifactProvider;
        this.artifactFilter = artifactFilter;
        this.scanArtifacts = scanArtifacts;
        this.keepArtifacts = keepArtifacts;
    }

    public void scan(ArtifactSearchResult artifactSearchResult, MavenRepositoryDescriptor repositoryDescriptor) throws IOException {
        EffectiveModelBuilder effectiveModelBuilder = new EffectiveModelBuilder(this.artifactProvider);
        GAVResolver gavResolver = new GAVResolver(this.scanner.getContext().getStore(), repositoryDescriptor);
        LinkedBlockingDeque<ArtifactTask.Result> queue = new LinkedBlockingDeque<ArtifactTask.Result>(500);
        ExecutorService pool = Executors.newFixedThreadPool(1, r -> new Thread(r, ArtifactTask.class.getSimpleName()));
        pool.submit(new ArtifactTask(artifactSearchResult, this.artifactFilter, this.scanArtifacts, queue, this.artifactProvider));
        Cache cache = Caffeine.newBuilder().maximumSize(256L).build();
        LOGGER.info("Starting scan.");
        StopWatch stopwatch = StopWatch.createStarted();
        long artifactCount = 0L;
        try {
            ArtifactTask.Result result;
            do {
                MavenArtifactDescriptor mavenArtifactDescriptor;
                if ((result = (ArtifactTask.Result)queue.take()) == ArtifactTask.Result.LAST) continue;
                ArtifactInfo artifactInfo = result.getArtifactInfo();
                ArtifactInfoCoordinates artifactCoordinates = new ArtifactInfoCoordinates(artifactInfo);
                LOGGER.debug("Processing '{}'.", (Object)artifactInfo);
                long lastModified = artifactInfo.getLastModified();
                boolean snapshot = MavenArtifactHelper.isSnapshot((Coordinates)artifactCoordinates);
                Optional<ArtifactResult> modelArtifactResult = result.getModelArtifactResult();
                MavenPomXmlDescriptor modelDescriptor = null;
                if (modelArtifactResult.isPresent()) {
                    Artifact modelArtifact = modelArtifactResult.get().getArtifact();
                    modelDescriptor = this.getModel(modelArtifact, snapshot, lastModified, repositoryDescriptor, effectiveModelBuilder, (Cache<String, MavenPomXmlDescriptor>)cache);
                } else {
                    LOGGER.warn("No model found for " + artifactInfo);
                }
                if (!EXTENSION_POM.equals(artifactInfo.getPackaging()) && (mavenArtifactDescriptor = repositoryDescriptor.findArtifact(MavenArtifactHelper.getId((Coordinates)artifactCoordinates))) == null) {
                    mavenArtifactDescriptor = this.getArtifact(artifactCoordinates, result.getArtifactResult(), snapshot, lastModified);
                    if (modelDescriptor != null) {
                        modelDescriptor.getDescribes().add(mavenArtifactDescriptor);
                    }
                    repositoryDescriptor.addArtifact(mavenArtifactDescriptor);
                    gavResolver.resolve(artifactCoordinates).getArtifacts().add(mavenArtifactDescriptor);
                }
                if (++artifactCount % 500L != 0L) continue;
                LOGGER.info("Processed {}/{} artifacts (duration: {}).", new Object[]{artifactCount, artifactSearchResult.getSize(), Duration.ofMillis(stopwatch.getTime())});
                this.scanner.getContext().getStore().flush();
            } while (result != ArtifactTask.Result.LAST);
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted while waiting for artifact result", e);
        }
        finally {
            pool.shutdownNow();
        }
        LOGGER.info("Finished scan: {} artifacts (duration: {}).", (Object)artifactCount, (Object)Duration.ofMillis(stopwatch.getTime()));
    }

    private MavenPomXmlDescriptor getModel(Artifact modelArtifact, boolean snapshot, long lastModified, MavenRepositoryDescriptor repositoryDescriptor, PomModelBuilder effectiveModelBuilder, Cache<String, MavenPomXmlDescriptor> cache) {
        AetherArtifactCoordinates modelCoordinates = new AetherArtifactCoordinates(modelArtifact);
        String fqn = MavenArtifactHelper.getId((Coordinates)modelCoordinates);
        return (MavenPomXmlDescriptor)cache.get((Object)fqn, key -> {
            MavenPomXmlDescriptor modelDescriptor;
            MavenPomXmlDescriptor mavenPomXmlDescriptor = modelDescriptor = snapshot ? repositoryDescriptor.findSnapshotModel(key) : repositoryDescriptor.findReleaseModel(key);
            if (modelDescriptor == null) {
                this.scanner.getContext().push(PomModelBuilder.class, (Object)effectiveModelBuilder);
                try {
                    LOGGER.info("Scanning model '{}'.", (Object)modelArtifact);
                    modelDescriptor = (MavenPomXmlDescriptor)this.scan(modelArtifact);
                }
                finally {
                    this.scanner.getContext().pop(PomModelBuilder.class);
                }
                this.markReleaseOrSnaphot(modelDescriptor, (Coordinates)modelCoordinates, snapshot, lastModified);
                repositoryDescriptor.addModel(modelDescriptor);
            }
            return modelDescriptor;
        });
    }

    private MavenArtifactDescriptor getArtifact(Coordinates artifactCoordinates, Optional<ArtifactResult> artifactResult, boolean snapshot, long lastModified) {
        MavenArtifactDescriptor mavenArtifactDescriptor;
        if (artifactResult.isPresent()) {
            Artifact artifact = artifactResult.get().getArtifact();
            LOGGER.info("Scanning artifact '{}'.", (Object)artifact);
            ArtifactDescriptor descriptor = (ArtifactDescriptor)this.scan(artifact);
            mavenArtifactDescriptor = (MavenArtifactDescriptor)this.scanner.getContext().getStore().addDescriptorType((Descriptor)descriptor, MavenArtifactDescriptor.class);
            MavenArtifactHelper.setCoordinates((MavenArtifactDescriptor)mavenArtifactDescriptor, (Coordinates)artifactCoordinates);
        } else {
            mavenArtifactDescriptor = ((ArtifactResolver)this.scanner.getContext().peek(ArtifactResolver.class)).resolve(artifactCoordinates, this.scanner.getContext());
        }
        this.markReleaseOrSnaphot(mavenArtifactDescriptor, artifactCoordinates, snapshot, lastModified);
        return mavenArtifactDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <D extends Descriptor> D scan(Artifact artifact) {
        File artifactFile = artifact.getFile();
        try {
            Descriptor descriptor = this.scanner.scan((Object)artifactFile, artifactFile.getAbsolutePath(), null);
            return (D)descriptor;
        }
        finally {
            if (!this.keepArtifacts) {
                artifactFile.delete();
            }
        }
    }

    private <D extends MavenDescriptor> ArtifactInfoDescriptor markReleaseOrSnaphot(D descriptor, Coordinates coordinates, boolean snapshot, Long lastModified) {
        Store store = this.scanner.getContext().getStore();
        ArtifactInfoDescriptor artifactInfoDescriptor = snapshot ? (ArtifactInfoDescriptor)store.addDescriptorType(descriptor, MavenSnapshotDescriptor.class) : (ArtifactInfoDescriptor)store.addDescriptorType(descriptor, MavenReleaseDescriptor.class);
        if (artifactInfoDescriptor.getFullQualifiedName() == null) {
            artifactInfoDescriptor.setFullQualifiedName(MavenArtifactHelper.getId((Coordinates)coordinates));
        }
        artifactInfoDescriptor.setLastModified(lastModified);
        return artifactInfoDescriptor;
    }
}

