/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.m2repo.impl.scanner;

import com.buschmais.jqassistant.plugin.m2repo.api.ArtifactProvider;
import com.buschmais.jqassistant.plugin.maven3.api.scanner.EffectiveModel;
import com.buschmais.jqassistant.plugin.maven3.api.scanner.PomModelBuilder;
import com.buschmais.jqassistant.plugin.maven3.api.scanner.RawModelBuilder;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collection;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.DefaultModelBuilder;
import org.apache.maven.model.building.DefaultModelBuilderFactory;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.FileModelSource;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.building.ModelProblemCollectorExt;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.apache.maven.model.validation.ModelValidator;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EffectiveModelBuilder
implements PomModelBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(EffectiveModelBuilder.class);
    private ModelResolverImpl modelResolver;
    private RawModelBuilder rawModelBuilder;

    public EffectiveModelBuilder(ArtifactProvider artifactProvider) {
        this.modelResolver = new ModelResolverImpl(artifactProvider);
        this.rawModelBuilder = new RawModelBuilder();
    }

    public Model getModel(File pomFile) throws IOException {
        DefaultModelBuilder builder = new DefaultModelBuilderFactory().newInstance();
        DefaultModelBuildingRequest req = new DefaultModelBuildingRequest();
        req.setProcessPlugins(false);
        req.setPomFile(pomFile);
        req.setModelResolver((ModelResolver)this.modelResolver);
        req.setValidationLevel(0);
        req.setSystemProperties(System.getProperties());
        builder.setModelValidator((ModelValidator)new ModelValidatorImpl());
        try {
            return new EffectiveModel(builder.build((ModelBuildingRequest)req).getEffectiveModel());
        }
        catch (ModelBuildingException e) {
            LOGGER.debug("Cannot build effective model for " + pomFile.getAbsolutePath(), (Throwable)e);
            LOGGER.warn("Building model for '{}' reported errors: {}", (Object)pomFile.getAbsolutePath(), (Object)e.getProblems());
            LOGGER.warn("Using raw model for " + pomFile.getAbsolutePath());
            return this.rawModelBuilder.getModel(pomFile);
        }
    }

    public class ModelResolverImpl
    implements ModelResolver {
        private ArtifactProvider artifactProvider;

        public ModelResolverImpl(ArtifactProvider artifactProvider) {
            this.artifactProvider = artifactProvider;
        }

        public ModelSource resolveModel(String groupId, String artifactId, String version) throws UnresolvableModelException {
            ArtifactResult artifactResult;
            DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, null, "pom", version);
            try {
                artifactResult = this.artifactProvider.getArtifact((Artifact)artifact);
            }
            catch (ArtifactResolutionException e) {
                throw new UnresolvableModelException("Cannot resolve artifact.", groupId, artifactId, version, (Throwable)e);
            }
            File file = artifactResult.getArtifact().getFile();
            return new FileModelSource(file);
        }

        public ModelSource resolveModel(Parent parent) throws UnresolvableModelException {
            return this.resolveModel(parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
        }

        public ModelSource resolveModel(Dependency dependency) throws UnresolvableModelException {
            return this.resolveModel(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion());
        }

        public void addRepository(Repository repository) {
        }

        public void addRepository(Repository repository, boolean replace) {
        }

        public ModelResolver newCopy() {
            return new ModelResolverImpl(this.artifactProvider);
        }
    }

    private static class ModelValidatorImpl
    implements ModelValidator {
        private ModelValidatorImpl() {
        }

        public void validateRawModel(Model model, ModelBuildingRequest request, ModelProblemCollector problems) {
        }

        public void validateEffectiveModel(Model model, ModelBuildingRequest request, ModelProblemCollector problems) {
            if (problems instanceof ModelProblemCollectorExt) {
                this.clearProblems(problems, "problems", true);
                this.clearProblems(problems, "severities", false);
            }
        }

        private void clearProblems(ModelProblemCollector problems, String field, boolean logValue) {
            try {
                Field problemsList = problems.getClass().getDeclaredField(field);
                problemsList.setAccessible(true);
                Collection value = (Collection)problemsList.get(problems);
                if (!value.isEmpty()) {
                    if (logValue) {
                        LOGGER.warn("Problems have been detected while validating POM model: {}.", (Object)value);
                    }
                    value.clear();
                }
            }
            catch (ReflectiveOperationException e) {
                LOGGER.warn("Cannot access field " + field, (Throwable)e);
            }
        }
    }
}

